/*
 * Decompiled with CFR 0.152.
 */
package net.deanly.structlayout.codec.helpers;

import net.deanly.structlayout.Field;
import net.deanly.structlayout.StructLayout;
import net.deanly.structlayout.annotation.StructField;
import net.deanly.structlayout.annotation.StructObjectField;
import net.deanly.structlayout.annotation.StructSequenceField;
import net.deanly.structlayout.annotation.StructSequenceObjectField;
import net.deanly.structlayout.annotation.StructTypeSelector;
import net.deanly.structlayout.dispatcher.StructTypeResolver;
import net.deanly.structlayout.type.CountableField;
import net.deanly.structlayout.type.DynamicSpanField;

public class CalculateStructureSizeHelper {
    public static int calculateEncodedObjectSize(Object instance) {
        byte[] encodedData = StructLayout.encode(instance);
        return encodedData.length;
    }

    public static int calculateClassSize(Class<?> type) {
        return 0;
    }

    public static int calculateNoDataClassSize(Class<?> type) {
        int totalSize = 0;
        for (java.lang.reflect.Field field : type.getDeclaredFields()) {
            field.setAccessible(true);
            if (field.isAnnotationPresent(StructField.class)) {
                totalSize += CalculateStructureSizeHelper.calculateStructFieldNoDataSize(field);
                continue;
            }
            if (field.isAnnotationPresent(StructObjectField.class)) {
                totalSize += CalculateStructureSizeHelper.calculateStructObjectFieldNoDataSize(field);
                continue;
            }
            if (field.isAnnotationPresent(StructSequenceField.class)) {
                totalSize += CalculateStructureSizeHelper.calculateStructSequenceFieldNoDataSize(field);
                continue;
            }
            if (!field.isAnnotationPresent(StructSequenceObjectField.class)) continue;
            totalSize += CalculateStructureSizeHelper.calculateStructSequenceObjectFieldNoDataSize(field);
        }
        return totalSize;
    }

    private static int calculateStructFieldNoDataSize(java.lang.reflect.Field field) {
        try {
            StructField annotation = field.getAnnotation(StructField.class);
            Class<Field<?>> fieldType = annotation.type();
            Field<?> fieldInstance = fieldType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (fieldInstance instanceof DynamicSpanField) {
                return ((DynamicSpanField)((Object)fieldInstance)).getNoDataSpan();
            }
            return fieldInstance.getSpan();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to calculate size for @StructField on field: " + field.getName(), e);
        }
    }

    private static int calculateStructObjectFieldNoDataSize(java.lang.reflect.Field field) {
        try {
            StructObjectField annotation = field.getAnnotation(StructObjectField.class);
            Class<?> fieldType = field.getType();
            if (fieldType.isInterface() && fieldType.isAnnotationPresent(StructTypeSelector.class)) {
                return StructTypeResolver.resolveNoDataSpan(fieldType);
            }
            return CalculateStructureSizeHelper.calculateNoDataClassSize(fieldType);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to calculate size for @StructObjectField on field: " + field.getName(), e);
        }
    }

    private static int calculateStructSequenceFieldNoDataSize(java.lang.reflect.Field field) {
        try {
            StructSequenceField annotation = field.getAnnotation(StructSequenceField.class);
            Class<CountableField<?>> lengthType = annotation.lengthType();
            Field lengthFieldInstance = lengthType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            int lengthTypeSize = lengthFieldInstance.getSpan();
            return lengthTypeSize;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to calculate size for @StructSequenceField on field: " + field.getName(), e);
        }
    }

    private static int calculateStructSequenceObjectFieldNoDataSize(java.lang.reflect.Field field) {
        try {
            StructSequenceObjectField annotation = field.getAnnotation(StructSequenceObjectField.class);
            Class<CountableField<?>> lengthType = annotation.lengthType();
            Field lengthFieldInstance = lengthType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            int lengthTypeSize = lengthFieldInstance.getSpan();
            return lengthTypeSize;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to calculate size for @StructSequenceObjectField on field: " + field.getName(), e);
        }
    }
}

