/*
 * Decompiled with CFR 0.152.
 */
package net.deanly.structlayout.codec.helpers;

import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import net.deanly.structlayout.Field;
import net.deanly.structlayout.annotation.StructField;
import net.deanly.structlayout.annotation.StructObjectField;
import net.deanly.structlayout.annotation.StructSequenceField;
import net.deanly.structlayout.annotation.StructSequenceObjectField;
import net.deanly.structlayout.exception.FieldOrderException;
import net.deanly.structlayout.support.Tuple2;
import net.deanly.structlayout.type.FieldBase;
import net.deanly.structlayout.type.helpers.DataTypeHelper;

public class FieldHelper {
    public static final Set<Class<?>> PRIMITIVE_WRAPPERS = Set.of(Integer.class, Long.class, Short.class, Byte.class, Double.class, Float.class, Boolean.class, Character.class);

    public static List<java.lang.reflect.Field> getOrderedFields(java.lang.reflect.Field[] fields) {
        ArrayList<java.lang.reflect.Field> orderedFields = new ArrayList<java.lang.reflect.Field>();
        for (java.lang.reflect.Field field : fields) {
            if (!field.isAnnotationPresent(StructSequenceField.class) && !field.isAnnotationPresent(StructObjectField.class) && !field.isAnnotationPresent(StructField.class) && !field.isAnnotationPresent(StructSequenceObjectField.class)) continue;
            orderedFields.add(field);
        }
        orderedFields.sort(Comparator.comparingInt(FieldHelper::getOrderValue));
        return orderedFields;
    }

    public static List<java.lang.reflect.Field> getOrderedFields(List<java.lang.reflect.Field> fields) {
        ArrayList<java.lang.reflect.Field> orderedFields = new ArrayList<java.lang.reflect.Field>();
        for (java.lang.reflect.Field field : fields) {
            if (!field.isAnnotationPresent(StructSequenceField.class) && !field.isAnnotationPresent(StructObjectField.class) && !field.isAnnotationPresent(StructField.class) && !field.isAnnotationPresent(StructSequenceObjectField.class)) continue;
            orderedFields.add(field);
        }
        orderedFields.sort(Comparator.comparingInt(FieldHelper::getOrderValue));
        return orderedFields;
    }

    public static List<Tuple2<java.lang.reflect.Field, Integer>> getOrderedFieldsWithOrder(List<java.lang.reflect.Field> fields) {
        ArrayList<Tuple2<java.lang.reflect.Field, Integer>> orderedFields = new ArrayList<Tuple2<java.lang.reflect.Field, Integer>>();
        for (java.lang.reflect.Field field : fields) {
            if (!field.isAnnotationPresent(StructSequenceField.class) && !field.isAnnotationPresent(StructObjectField.class) && !field.isAnnotationPresent(StructField.class) && !field.isAnnotationPresent(StructSequenceObjectField.class)) continue;
            int order = FieldHelper.getOrderValue(field);
            orderedFields.add(Tuple2.of(field, order));
        }
        orderedFields.sort(Comparator.comparingInt(t -> (Integer)t.second));
        return orderedFields;
    }

    public static int getOrderValue(java.lang.reflect.Field field) {
        if (field.isAnnotationPresent(StructSequenceField.class)) {
            return field.getAnnotation(StructSequenceField.class).order();
        }
        if (field.isAnnotationPresent(StructObjectField.class)) {
            return field.getAnnotation(StructObjectField.class).order();
        }
        if (field.isAnnotationPresent(StructField.class)) {
            return field.getAnnotation(StructField.class).order();
        }
        if (field.isAnnotationPresent(StructSequenceObjectField.class)) {
            return field.getAnnotation(StructSequenceObjectField.class).order();
        }
        throw new FieldOrderException(field.getName());
    }

    public static boolean isStructField(java.lang.reflect.Field field) {
        return field.isAnnotationPresent(StructField.class) || field.isAnnotationPresent(StructSequenceField.class) || field.isAnnotationPresent(StructObjectField.class) || field.isAnnotationPresent(StructSequenceObjectField.class);
    }

    public static List<java.lang.reflect.Field> getAllDeclaredFieldsIncludingSuperclasses(Class<?> clazz) {
        ArrayList<java.lang.reflect.Field> fields = new ArrayList<java.lang.reflect.Field>();
        while (clazz != null && clazz != Object.class) {
            for (java.lang.reflect.Field field : clazz.getDeclaredFields()) {
                if (!FieldHelper.isStructField(field)) continue;
                fields.add(field);
            }
            clazz = clazz.getSuperclass();
        }
        return fields;
    }

    public static boolean isFieldTypeApplicable(Class<?> structFieldType, Class<? extends Field<?>> fieldType) {
        Class<?> dataTypeFieldType = FieldBase.getGenericTypeAsObject(fieldType);
        if (FieldHelper.isNumericType(structFieldType) && FieldHelper.isNumericType(dataTypeFieldType)) {
            return true;
        }
        return DataTypeHelper.matches(fieldType, structFieldType);
    }

    private static boolean isNumericType(Class<?> type) {
        return Number.class.isAssignableFrom(type) || type == Byte.TYPE || type == Short.TYPE || type == Integer.TYPE || type == Long.TYPE || type == Float.TYPE || type == Double.TYPE;
    }

    public static boolean isPrimitiveArrayApplicable(Class<?> componentType, Class<? extends Field<?>> fieldType) {
        Class<?> expectedType = FieldBase.getGenericTypeAsObject(fieldType);
        return componentType.isPrimitive() && (componentType == Byte.TYPE && expectedType == Byte.class || componentType == Short.TYPE && expectedType == Short.class || componentType == Integer.TYPE && expectedType == Integer.class || componentType == Long.TYPE && expectedType == Long.class || componentType == Float.TYPE && expectedType == Float.class || componentType == Double.TYPE && expectedType == Double.class);
    }

    public static Class<?> extractLayoutGenericType(Class<? extends Field<?>> layoutClass) {
        try {
            return (Class)((ParameterizedType)layoutClass.getGenericSuperclass()).getActualTypeArguments()[0];
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Unable to extract generic type from Layout class '%s'", layoutClass.getName()), e);
        }
    }
}

