/*
 * Decompiled with CFR 0.152.
 */
package net.deanly.structlayout.codec.helpers;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.UUID;
import java.util.function.Predicate;
import net.deanly.structlayout.Field;
import net.deanly.structlayout.exception.TypeConversionException;
import net.deanly.structlayout.type.FieldBase;
import net.deanly.structlayout.type.guava.UnsignedLong;

public class TypeConverterHelper {
    public static Object convertWithValidation(Object value, Class<?> targetType, Predicate<Object> validator) {
        Object result = TypeConverterHelper.convertToType(value, targetType);
        if (!validator.test(result)) {
            throw new IllegalArgumentException("Value is invalid: " + value);
        }
        return result;
    }

    public static Object convertToLayoutType(Object value, Class<? extends Field<?>> targetType) {
        if (value == null) {
            return TypeConverterHelper.handleNullValueAllowNull(value, targetType);
        }
        return TypeConverterHelper.convertToType(value, FieldBase.getGenericTypeAsObject(targetType));
    }

    public static Object convertToType(Object value, Class<?> targetType) {
        if (value == null) {
            return TypeConverterHelper.handleNullValueAllowNull(value, targetType);
        }
        if (Number.class.isAssignableFrom(targetType) || TypeConverterHelper.isPrimitiveNumberType(targetType)) {
            if (value instanceof Number) {
                return TypeConverterHelper.convertNumber((Number)value, targetType);
            }
            if (value instanceof String) {
                return TypeConverterHelper.convertFromString((String)value, targetType);
            }
            throw new TypeConversionException("Cannot convert non-numeric value to numeric type: " + targetType);
        }
        if (targetType == String.class) {
            if (value instanceof String) {
                return value;
            }
            return value.toString();
        }
        if (targetType == Boolean.class || targetType == Boolean.TYPE) {
            if (value instanceof String) {
                return Boolean.valueOf((String)value);
            }
            if (value instanceof Number) {
                return Integer.parseInt(String.valueOf(value)) != 0;
            }
        }
        if ((targetType == Character.class || targetType == Character.TYPE) && value instanceof String) {
            return TypeConverterHelper.convertFromString((String)value, targetType);
        }
        if (targetType.isInstance(value)) {
            return value;
        }
        Object specialTypeResult = TypeConverterHelper.convertToSpecialTypes(value, targetType);
        if (specialTypeResult != null) {
            return specialTypeResult;
        }
        throw new TypeConversionException("Cannot convert value of type " + value.getClass() + " to target type " + targetType);
    }

    private static boolean isPrimitiveNumberType(Class<?> type) {
        return type == Byte.TYPE || type == Short.TYPE || type == Integer.TYPE || type == Long.TYPE || type == Float.TYPE || type == Double.TYPE;
    }

    private static Object convertNumber(Number value, Class<?> targetClass) {
        if (value instanceof Float && ((Float)value).isNaN()) {
            return TypeConverterHelper.handleNaN(targetClass);
        }
        if (value instanceof Double && ((Double)value).isNaN()) {
            return TypeConverterHelper.handleNaN(targetClass);
        }
        if (Double.isInfinite(value.doubleValue())) {
            return TypeConverterHelper.handleInfinity(targetClass, value.doubleValue());
        }
        if (targetClass == Byte.class || targetClass == Byte.TYPE) {
            TypeConverterHelper.checkRange(value.longValue(), -128L, 127L, targetClass);
            return value.byteValue();
        }
        if (targetClass == Short.class || targetClass == Short.TYPE) {
            TypeConverterHelper.checkRange(value.longValue(), -32768L, 32767L, targetClass);
            return value.shortValue();
        }
        if (targetClass == Integer.class || targetClass == Integer.TYPE) {
            TypeConverterHelper.checkRange(value.longValue(), Integer.MIN_VALUE, Integer.MAX_VALUE, targetClass);
            return value.intValue();
        }
        if (targetClass == Long.class || targetClass == Long.TYPE) {
            return value.longValue();
        }
        if (targetClass == Float.class || targetClass == Float.TYPE) {
            TypeConverterHelper.checkFloatRange(value.doubleValue(), 1.4E-45f, 3.4028234663852886E38, targetClass);
            return Float.valueOf(value.floatValue());
        }
        if (targetClass == Double.class || targetClass == Double.TYPE) {
            return value.doubleValue();
        }
        if (targetClass == UnsignedLong.class) {
            return UnsignedLong.valueOf(value.toString());
        }
        if (targetClass == BigInteger.class) {
            return new BigInteger(value.toString());
        }
        throw new TypeConversionException("Unsupported number conversion to type: " + targetClass);
    }

    private static void checkRange(long value, long min, long max, Class<?> targetClass) {
        if (value < min || value > max) {
            throw new TypeConversionException("Value " + value + " is out of range for type: " + targetClass.getSimpleName());
        }
    }

    private static void checkFloatRange(double value, double min, double max, Class<?> targetClass) {
        if (value < -max || value > max) {
            throw new TypeConversionException("Value " + value + " is out of range for type: " + targetClass.getSimpleName());
        }
    }

    private static Object convertFromString(String value, Class<?> targetClass) {
        try {
            if (targetClass == String.class) {
                return value;
            }
            if (targetClass == Short.class || targetClass == Short.TYPE) {
                return Short.valueOf(value);
            }
            if (targetClass == Byte.class || targetClass == Byte.TYPE) {
                return Byte.valueOf(value);
            }
            if (targetClass == Integer.class || targetClass == Integer.TYPE) {
                return Integer.valueOf(value);
            }
            if (targetClass == Long.class || targetClass == Long.TYPE) {
                return Long.valueOf(value);
            }
            if (targetClass == Float.class || targetClass == Float.TYPE) {
                return Float.valueOf(value);
            }
            if (targetClass == Double.class || targetClass == Double.TYPE) {
                return Double.valueOf(value);
            }
            if (targetClass == BigInteger.class) {
                return new BigInteger(value);
            }
            if (targetClass == BigDecimal.class) {
                return new BigDecimal(value);
            }
            if (targetClass == Boolean.class || targetClass == Boolean.TYPE) {
                return Boolean.valueOf(value);
            }
            if (targetClass == Character.class || targetClass == Character.TYPE) {
                if (value.length() != 1) {
                    throw new TypeConversionException("Cannot convert String to Character: " + value);
                }
                return Character.valueOf(value.charAt(0));
            }
        }
        catch (NumberFormatException e) {
            throw new TypeConversionException("Cannot convert String to " + targetClass + ": " + value, e);
        }
        throw new TypeConversionException("Unsupported String conversion to type: " + targetClass);
    }

    private static Object convertToSpecialTypes(Object value, Class<?> targetClass) {
        if (targetClass == BigDecimal.class) {
            return new BigDecimal(value.toString());
        }
        if (targetClass == UnsignedLong.class) {
            return UnsignedLong.valueOf(value.toString());
        }
        if (targetClass == BigInteger.class) {
            return new BigInteger(value.toString());
        }
        if (targetClass == LocalDate.class) {
            return LocalDate.parse(value.toString());
        }
        if (targetClass == LocalDateTime.class) {
            return LocalDateTime.parse(value.toString());
        }
        if (targetClass == ZonedDateTime.class) {
            return ZonedDateTime.parse(value.toString());
        }
        if (targetClass.isEnum()) {
            return Enum.valueOf(targetClass, value.toString());
        }
        if (targetClass == UUID.class) {
            return UUID.fromString(value.toString());
        }
        return null;
    }

    private static Object handleNullValue(Class<?> targetType) {
        if (Number.class.isAssignableFrom(targetType) || targetType.isPrimitive()) {
            if (targetType == Integer.class || targetType == Integer.TYPE) {
                return 0;
            }
            if (targetType == Long.class || targetType == Long.TYPE) {
                return 0L;
            }
            if (targetType == Float.class || targetType == Float.TYPE) {
                return Float.valueOf(0.0f);
            }
            if (targetType == Double.class || targetType == Double.TYPE) {
                return 0.0;
            }
            if (targetType == Short.class || targetType == Short.TYPE) {
                return (short)0;
            }
            if (targetType == Byte.class || targetType == Byte.TYPE) {
                return (byte)0;
            }
        }
        if (targetType == Boolean.class || targetType == Boolean.TYPE) {
            return false;
        }
        if (targetType == Character.class || targetType == Character.TYPE) {
            return Character.valueOf('\u0000');
        }
        if (targetType == String.class) {
            return "";
        }
        return null;
    }

    public static Object handleNullValueAllowNull(Object value, Class<?> targetType) {
        if (value == null) {
            if (!targetType.isPrimitive()) {
                return null;
            }
            return TypeConverterHelper.handleNullValue(targetType);
        }
        return TypeConverterHelper.convertToType(value, targetType);
    }

    private static Object handleNaN(Class<?> targetClass) {
        if (targetClass == Float.class || targetClass == Float.TYPE) {
            return Float.valueOf(0.0f);
        }
        if (targetClass == Double.class || targetClass == Double.TYPE) {
            return 0.0;
        }
        throw new TypeConversionException("Cannot convert NaN to non-floating-point type: " + targetClass);
    }

    private static Object handleInfinity(Class<?> targetClass, double value) {
        if (targetClass == Float.class || targetClass == Float.TYPE) {
            return Float.valueOf(value > 0.0 ? Float.MAX_VALUE : -3.4028235E38f);
        }
        if (targetClass == Double.class || targetClass == Double.TYPE) {
            return value > 0.0 ? Double.MAX_VALUE : -1.7976931348623157E308;
        }
        throw new TypeConversionException("Cannot convert Infinity to non-floating-point type: " + targetClass);
    }
}

