/*
 * Decompiled with CFR 0.152.
 */
package net.deanly.structlayout.dispatcher;

import java.lang.reflect.InvocationTargetException;
import net.deanly.structlayout.annotation.StructTypeSelector;
import net.deanly.structlayout.dispatcher.StructTypeDispatcher;

public class StructTypeResolver {
    public static <F extends T, T> Class<F> resolveClass(byte[] data, Class<T> baseType, int startOffset) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        StructTypeSelector selector = baseType.getAnnotation(StructTypeSelector.class);
        if (selector == null) {
            throw new IllegalArgumentException("Missing @StructTypeSelector on " + baseType.getName());
        }
        StructTypeDispatcher dispatcher = selector.dispatcher().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        Class<?> concreteClass = dispatcher.dispatch(data, startOffset);
        if (concreteClass == null) {
            throw new IllegalArgumentException("No matching class found for data: " + data[0]);
        }
        if (!baseType.isAssignableFrom(concreteClass)) {
            throw new IllegalArgumentException("Resolved class " + concreteClass.getName() + " does not extend or implement " + baseType.getName());
        }
        return concreteClass;
    }

    public static int resolveNoDataSpan(Class<?> baseType) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        StructTypeSelector selector = baseType.getAnnotation(StructTypeSelector.class);
        if (selector == null) {
            throw new IllegalArgumentException("Missing @StructTypeSelector on " + baseType.getName());
        }
        StructTypeDispatcher dispatcher = selector.dispatcher().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        return dispatcher.getNoDataSpan();
    }
}

