/*
 * Decompiled with CFR 0.152.
 */
package net.deanly.structlayout.factory;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import net.deanly.structlayout.Field;
import net.deanly.structlayout.exception.LayoutInitializationException;
import net.deanly.structlayout.exception.NoDefaultConstructorException;
import net.deanly.structlayout.type.FieldBase;
import net.deanly.structlayout.type.basic.BasicType;

public class ClassFactory {
    public static FieldBase<?> createInstance(BasicType basicType) {
        if (!(basicType instanceof FieldBase)) {
            throw new IllegalArgumentException("Provided BasicType does not implement Field: " + basicType.getClass().getName());
        }
        Class<?> fieldClass = basicType.getClass();
        return ClassFactory.createLayoutInstance(fieldClass);
    }

    public static <T> T createNoArgumentsInstance(Class<T> type) {
        try {
            if (type.isMemberClass() && !Modifier.isStatic(type.getModifiers())) {
                throw new NoDefaultConstructorException("Class '" + type.getName() + "' is a non-static inner class and cannot be instantiated. Make it static or use another design.");
            }
            if (type.isLocalClass()) {
                throw new LayoutInitializationException("Class '" + type.getName() + "' is a local class defined inside a method. Local classes cannot be instantiated reflectively. Consider refactoring it to a static nested class or a top-level class.");
            }
            return type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (NoDefaultConstructorException e) {
            throw e;
        }
        catch (NoSuchMethodException e) {
            throw new LayoutInitializationException("The Layout class '" + type.getName() + "' must have a public no-arguments constructor.", e);
        }
        catch (IllegalAccessException e) {
            throw new LayoutInitializationException("Cannot access the constructor of Layout class: " + type.getName(), e);
        }
        catch (InstantiationException e) {
            throw new LayoutInitializationException("Cannot instantiate Layout class: " + type.getName(), e);
        }
        catch (InvocationTargetException e) {
            throw new LayoutInitializationException("Exception occurred while initializing Layout class: " + type.getName() + ". Check the constructor logic.", e.getCause());
        }
        catch (Exception e) {
            throw new LayoutInitializationException("Failed to instantiate Layout class: " + type.getName(), e);
        }
    }

    public static <T> FieldBase<T> createLayoutInstance(Class<? extends Field<?>> layoutClass) {
        try {
            if (layoutClass.isMemberClass() && !Modifier.isStatic(layoutClass.getModifiers())) {
                throw new LayoutInitializationException("The Field class '" + layoutClass.getName() + "' is a non-static inner class. Make it static or redesign it properly.");
            }
            if (layoutClass.isLocalClass()) {
                throw new LayoutInitializationException("Class '" + layoutClass.getName() + "' is a local class defined inside a method. Local classes cannot be instantiated reflectively. Consider refactoring it to a static nested class or a top-level class.");
            }
            Constructor<?>[] constructors = layoutClass.getDeclaredConstructors();
            boolean hasNoArgConstructor = false;
            for (Constructor<?> constructor : constructors) {
                if (constructor.getParameterCount() != 0) continue;
                hasNoArgConstructor = true;
                break;
            }
            if (!hasNoArgConstructor) {
                throw new LayoutInitializationException("The Field class '" + layoutClass.getName() + "' does not have a valid no-arguments constructor. If it is a non-static inner class, make it 'static' or define its constructor properly.");
            }
            Constructor<Field<?>> constructor = layoutClass.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return (FieldBase)constructor.newInstance(new Object[0]);
        }
        catch (LayoutInitializationException e) {
            throw e;
        }
        catch (NoSuchMethodException e) {
            throw new LayoutInitializationException("The Field class '" + layoutClass.getName() + "' must have a public no-arguments constructor.", e);
        }
        catch (IllegalAccessException e) {
            throw new LayoutInitializationException("Cannot access the constructor of Field class: " + layoutClass.getName(), e);
        }
        catch (InstantiationException e) {
            throw new LayoutInitializationException("Cannot instantiate Field class: " + layoutClass.getName(), e);
        }
        catch (InvocationTargetException e) {
            throw new LayoutInitializationException("Exception occurred while initializing Field class: " + layoutClass.getName() + ". Check the constructor logic.", e.getCause());
        }
        catch (Exception e) {
            throw new LayoutInitializationException("Failed to instantiate Field class: " + layoutClass.getName(), e);
        }
    }
}

