/*
 * Decompiled with CFR 0.152.
 */
package net.deanly.structlayout.type;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import lombok.Generated;
import net.deanly.structlayout.Field;

public abstract class FieldBase<T>
implements Field<T> {
    private final int span;
    private final Class<T> valueType;

    public FieldBase(int span, Class<T> clazz) {
        this.span = span;
        this.valueType = clazz;
    }

    public FieldBase(int span) {
        ParameterizedType parameterizedType = (ParameterizedType)this.getClass().getGenericSuperclass();
        Class clazz = (Class)parameterizedType.getActualTypeArguments()[0];
        this.span = span;
        this.valueType = clazz;
    }

    @Override
    public abstract byte[] encode(T var1);

    @Override
    public abstract T decode(byte[] var1, int var2);

    protected void validateLength(byte[] data, int offset) {
        if (data == null) {
            throw new IllegalArgumentException("Data cannot be null.");
        }
        if (offset < 0 || offset + this.span > data.length) {
            String fullHex = this.bytesToHex(data);
            throw new IllegalArgumentException(String.format("Illegal decoding request. Data is insufficient for span: %d, offset: %d, data length: %d. Full data in HEX: [%s]", this.span, offset, data.length, fullHex));
        }
    }

    public String bytesToHex(byte[] data) {
        if (data == null || data.length == 0) {
            return "Empty or null data";
        }
        StringBuilder hexBuilder = new StringBuilder(data.length * 2);
        for (int i = 0; i < data.length; ++i) {
            hexBuilder.append(String.format("%02X", data[i]));
            if (i >= data.length - 1) continue;
            hexBuilder.append(" ");
        }
        return hexBuilder.toString();
    }

    public String bytesToHex(byte[] data, int offset) {
        if (data == null) {
            throw new IllegalArgumentException("Cannot convert null data to hex.");
        }
        if (offset < 0 || offset + this.getSpan() > data.length) {
            throw new IllegalArgumentException("Invalid offset or length for hex conversion. Data length: " + data.length + ", offset: " + offset + ", length: " + this.getSpan());
        }
        StringBuilder hexBuilder = new StringBuilder(this.getSpan() * 2);
        for (int i = 0; i < this.getSpan(); ++i) {
            hexBuilder.append(String.format("%02X", data[offset + i]));
            if (i >= this.getSpan() - 1) continue;
            hexBuilder.append(" ");
        }
        return hexBuilder.toString();
    }

    public Class<T> getGenericType() {
        Type superClass = this.getClass().getGenericSuperclass();
        if (superClass instanceof ParameterizedType) {
            ParameterizedType parameterized = (ParameterizedType)superClass;
            return (Class)parameterized.getActualTypeArguments()[0];
        }
        return null;
    }

    public static <T> Class<T> getGenericType(Class<? extends Field<T>> fieldClass) {
        ParameterizedType parameterizedType;
        Type typeArgument;
        Type superClass = fieldClass.getGenericSuperclass();
        if (superClass instanceof ParameterizedType && (typeArgument = (parameterizedType = (ParameterizedType)superClass).getActualTypeArguments()[0]) instanceof Class) {
            return (Class)typeArgument;
        }
        return null;
    }

    public static Class<?> getGenericTypeAsObject(Class<? extends Field<?>> fieldClass) {
        ParameterizedType parameterizedType;
        Type typeArgument;
        Type superClass = fieldClass.getGenericSuperclass();
        if (superClass instanceof ParameterizedType && (typeArgument = (parameterizedType = (ParameterizedType)superClass).getActualTypeArguments()[0]) instanceof Class) {
            return (Class)typeArgument;
        }
        return null;
    }

    private static boolean isNumericClass(Class<?> type) {
        return Number.class.isAssignableFrom(type) || type.isPrimitive() && (type == Byte.TYPE || type == Short.TYPE || type == Integer.TYPE || type == Long.TYPE || type == Float.TYPE || type == Double.TYPE);
    }

    private static boolean isStringClass(Class<?> type) {
        return type == String.class;
    }

    public static boolean isNumericType(Class<? extends Field<?>> fieldClass) {
        Class<?> genericType = FieldBase.getGenericTypeAsObject(fieldClass);
        return genericType != null && FieldBase.isNumericClass(genericType);
    }

    public static boolean isStringType(Class<? extends Field<?>> fieldClass) {
        Class<?> genericType = FieldBase.getGenericTypeAsObject(fieldClass);
        return genericType != null && FieldBase.isStringClass(genericType);
    }

    @Override
    @Generated
    public int getSpan() {
        return this.span;
    }

    @Generated
    public Class<T> getValueType() {
        return this.valueType;
    }
}

