/*
 * Decompiled with CFR 0.152.
 */
package net.deanly.structlayout.type.advanced;

import lombok.Generated;
import net.deanly.structlayout.type.DynamicSpanField;
import net.deanly.structlayout.type.FieldBase;

public class OffsetField<T>
extends FieldBase<T>
implements DynamicSpanField {
    private final FieldBase<T> field;
    private final int offset;
    private int span;

    public OffsetField(FieldBase<T> field, int offset) {
        super(field instanceof DynamicSpanField ? -1 : field.getSpan(), field.getValueType());
        if (field == null) {
            throw new IllegalArgumentException("Base layout must not be null.");
        }
        this.field = field;
        this.offset = offset;
    }

    @Override
    public int calculateSpan(byte[] data, int currentOffset) {
        return this.field instanceof DynamicSpanField ? ((DynamicSpanField)((Object)this.field)).calculateSpan(data, currentOffset + this.offset) : this.field.getSpan();
    }

    @Override
    public int getNoDataSpan() {
        return 0;
    }

    @Override
    public T decode(byte[] data, int currentOffset) {
        int adjustedOffset = currentOffset + this.offset;
        if (adjustedOffset < 0 || adjustedOffset >= data.length) {
            throw new IllegalArgumentException("Offset is out of bounds.");
        }
        return this.field.decode(data, adjustedOffset);
    }

    @Override
    public byte[] encode(T value) {
        return this.field.encode(value);
    }

    @Generated
    public FieldBase<T> getField() {
        return this.field;
    }

    @Generated
    public int getOffset() {
        return this.offset;
    }

    @Override
    @Generated
    public int getSpan() {
        return this.span;
    }
}

