/*
 * Decompiled with CFR 0.152.
 */
package net.deanly.structlayout.type.basic;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import net.deanly.structlayout.type.FieldBase;

public abstract class AbstractFixedStringField
extends FieldBase<String> {
    protected AbstractFixedStringField(int fixedSpan) {
        super(fixedSpan, String.class);
    }

    @Override
    public String decode(byte[] data, int offset) {
        this.validateLength(data, offset);
        byte[] fixedBytes = Arrays.copyOfRange(data, offset, offset + this.getSpan());
        return new String(fixedBytes, StandardCharsets.UTF_8).trim();
    }

    @Override
    public byte[] encode(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value cannot be null.");
        }
        byte[] stringBytes = value.getBytes(StandardCharsets.UTF_8);
        if (stringBytes.length > this.getSpan()) {
            throw new IllegalArgumentException("String length exceeds fixed span of " + this.getSpan() + " bytes.");
        }
        byte[] fixedBytes = new byte[this.getSpan()];
        System.arraycopy(stringBytes, 0, fixedBytes, 0, stringBytes.length);
        Arrays.fill(fixedBytes, stringBytes.length, this.getSpan(), (byte)0);
        return fixedBytes;
    }
}

