/*
 * Decompiled with CFR 0.152.
 */
package net.deanly.structlayout.type.basic;

import net.deanly.structlayout.type.FieldBase;
import net.deanly.structlayout.type.basic.BasicType;

public class Float32LEField
extends FieldBase<Float>
implements BasicType {
    public Float32LEField() {
        super(4, Float.class);
    }

    @Override
    public Float decode(byte[] data, int offset) {
        this.validateLength(data, offset);
        int intBits = data[offset] & 0xFF | (data[offset + 1] & 0xFF) << 8 | (data[offset + 2] & 0xFF) << 16 | (data[offset + 3] & 0xFF) << 24;
        return Float.valueOf(Float.intBitsToFloat(intBits));
    }

    @Override
    public byte[] encode(Float value) {
        if (value == null) {
            throw new IllegalArgumentException("Value cannot be null.");
        }
        if (value.floatValue() > Float.MAX_VALUE || value.floatValue() < -3.4028235E38f) {
            throw new IllegalArgumentException(String.format("Value %s exceeds the range of Float32 (Valid range: [%s, %s])", value, Float.valueOf(-3.4028235E38f), Float.valueOf(Float.MAX_VALUE)));
        }
        byte[] data = new byte[4];
        int intBits = Float.floatToIntBits(value.floatValue());
        data[0] = (byte)(intBits & 0xFF);
        data[1] = (byte)(intBits >> 8 & 0xFF);
        data[2] = (byte)(intBits >> 16 & 0xFF);
        data[3] = (byte)(intBits >> 24 & 0xFF);
        return data;
    }
}

