/*
 * Decompiled with CFR 0.152.
 */
package net.deanly.structlayout.type.basic;

import net.deanly.structlayout.type.FieldBase;
import net.deanly.structlayout.type.basic.BasicType;

public class Float64BEField
extends FieldBase<Double>
implements BasicType {
    public Float64BEField() {
        super(8, Double.class);
    }

    @Override
    public Double decode(byte[] data, int offset) {
        if (data == null) {
            throw new IllegalArgumentException("Data cannot be null.");
        }
        if (offset < 0 || offset + 8 > data.length) {
            throw new IllegalArgumentException("Invalid offset or insufficient data length.");
        }
        long longBits = (long)(data[offset] & 0xFF) << 56 | (long)(data[offset + 1] & 0xFF) << 48 | (long)(data[offset + 2] & 0xFF) << 40 | (long)(data[offset + 3] & 0xFF) << 32 | (long)(data[offset + 4] & 0xFF) << 24 | (long)(data[offset + 5] & 0xFF) << 16 | (long)(data[offset + 6] & 0xFF) << 8 | (long)(data[offset + 7] & 0xFF);
        return Double.longBitsToDouble(longBits);
    }

    @Override
    public byte[] encode(Double value) {
        if (value == null) {
            throw new IllegalArgumentException("Value cannot be null.");
        }
        byte[] data = new byte[8];
        long longBits = Double.doubleToLongBits(value);
        for (int i = 7; i >= 0; --i) {
            data[i] = (byte)(longBits & 0xFFL);
            longBits >>= 8;
        }
        return data;
    }
}

