/*
 * Decompiled with CFR 0.152.
 */
package net.deanly.structlayout.type.basic;

import net.deanly.structlayout.type.CountableField;
import net.deanly.structlayout.type.FieldBase;

public class Int16LEField
extends FieldBase<Short>
implements CountableField<Short> {
    public Int16LEField() {
        super(2, Short.class);
    }

    @Override
    public Short decode(byte[] data, int offset) {
        if (data == null || offset + this.getSpan() > data.length) {
            throw new IllegalArgumentException("Data is invalid or offset exceeds length.");
        }
        return (short)(data[offset] & 0xFF | (data[offset + 1] & 0xFF) << 8);
    }

    @Override
    public byte[] encode(Short value) {
        if (value == null) {
            throw new IllegalArgumentException("Value cannot be null.");
        }
        return new byte[]{(byte)(value & 0xFF), (byte)(value >> 8 & 0xFF)};
    }
}

