/*
 * Decompiled with CFR 0.152.
 */
package net.deanly.structlayout.type.basic;

import net.deanly.structlayout.type.CountableField;
import net.deanly.structlayout.type.FieldBase;

public class Int32BEField
extends FieldBase<Integer>
implements CountableField<Integer> {
    public Int32BEField() {
        super(4, Integer.class);
    }

    @Override
    public Integer decode(byte[] data, int offset) {
        if (data == null) {
            throw new IllegalArgumentException("Data cannot be null.");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("Offset cannot be negative. Given offset: " + offset);
        }
        if (data.length - offset < this.getSpan()) {
            throw new IllegalArgumentException("Data length is insufficient for decoding. Required: " + this.getSpan() + " bytes, but available: " + (data.length - offset) + " bytes from offset " + offset);
        }
        int result = 0;
        for (int i = 0; i < this.getSpan(); ++i) {
            result = result << 8 | data[offset + i] & 0xFF;
        }
        return result;
    }

    @Override
    public byte[] encode(Integer value) {
        if (value == null) {
            throw new IllegalArgumentException("Value cannot be null.");
        }
        byte[] data = new byte[this.getSpan()];
        for (int i = this.getSpan() - 1; i >= 0; --i) {
            data[i] = (byte)(value & 0xFF);
            value = value >> 8;
        }
        return data;
    }
}

