/*
 * Decompiled with CFR 0.152.
 */
package net.deanly.structlayout.type.basic;

import net.deanly.structlayout.type.CountableField;
import net.deanly.structlayout.type.FieldBase;

public class Int32LEField
extends FieldBase<Integer>
implements CountableField<Integer> {
    public Int32LEField() {
        super(4, Integer.class);
    }

    @Override
    public Integer decode(byte[] data, int offset) {
        if (data == null) {
            throw new IllegalArgumentException("Data cannot be null.");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("Offset cannot be negative. Given offset: " + offset);
        }
        if (data.length - offset < this.getSpan()) {
            throw new IllegalArgumentException("Data length is insufficient for decoding. Required: " + this.getSpan() + " bytes, but available: " + (data.length - offset) + " bytes from offset " + offset);
        }
        int result = 0;
        for (int i = 0; i < this.getSpan(); ++i) {
            result |= (data[offset + i] & 0xFF) << 8 * i;
        }
        return result;
    }

    @Override
    public byte[] encode(Integer value) {
        if (value == null) {
            throw new IllegalArgumentException("Value cannot be null.");
        }
        byte[] data = new byte[this.getSpan()];
        for (int i = 0; i < this.getSpan(); ++i) {
            data[i] = (byte)(value >> 8 * i & 0xFF);
        }
        return data;
    }
}

