/*
 * Decompiled with CFR 0.152.
 */
package net.deanly.structlayout.type.basic;

import net.deanly.structlayout.type.CountableField;
import net.deanly.structlayout.type.FieldBase;

public class Int64LEField
extends FieldBase<Long>
implements CountableField<Long> {
    public Int64LEField() {
        super(8, Long.class);
    }

    @Override
    public Long decode(byte[] data, int offset) {
        if (data == null) {
            throw new IllegalArgumentException("Data cannot be null.");
        }
        if (offset < 0 || offset + 8 > data.length) {
            throw new IllegalArgumentException("Invalid offset or insufficient data length.");
        }
        long lo32 = (long)(data[offset] & 0xFF) | (long)(data[offset + 1] & 0xFF) << 8 | (long)(data[offset + 2] & 0xFF) << 16 | (long)(data[offset + 3] & 0xFF) << 24;
        long hi32 = (long)(data[offset + 4] & 0xFF) | (long)(data[offset + 5] & 0xFF) << 8 | (long)(data[offset + 6] & 0xFF) << 16 | (long)(data[offset + 7] & 0xFF) << 24;
        return hi32 << 32 | lo32;
    }

    @Override
    public byte[] encode(Long value) {
        if (value == null) {
            throw new IllegalArgumentException("Value cannot be null.");
        }
        byte[] data = new byte[8];
        for (int i = 0; i < 8; ++i) {
            data[i] = (byte)(value >> 8 * i & 0xFFL);
        }
        return data;
    }
}

