/*
 * Decompiled with CFR 0.152.
 */
package net.deanly.structlayout.type.basic;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import net.deanly.structlayout.type.DynamicSpanField;
import net.deanly.structlayout.type.FieldBase;
import net.deanly.structlayout.type.basic.BasicType;

public class StringCField
extends FieldBase<String>
implements DynamicSpanField,
BasicType {
    private final Charset charset;
    private int span;

    public StringCField() {
        this(StandardCharsets.US_ASCII);
    }

    public StringCField(Charset charset) {
        super(-1, String.class);
        this.charset = charset;
    }

    @Override
    public byte[] encode(String value) {
        if (value == null) {
            return new byte[0];
        }
        byte[] stringBytes = value.getBytes(this.charset);
        byte[] result = new byte[stringBytes.length + 1];
        System.arraycopy(stringBytes, 0, result, 0, stringBytes.length);
        result[stringBytes.length] = 0;
        this.setSpan(result.length);
        return result;
    }

    @Override
    public String decode(byte[] bytes, int offset) {
        int length = this.calculateSpan(bytes, offset);
        this.setSpan(length);
        ArrayList<Byte> resultBytes = new ArrayList<Byte>();
        for (int i = offset; i < bytes.length && bytes[i] != 0; ++i) {
            resultBytes.add(bytes[i]);
        }
        byte[] stringBytes = new byte[resultBytes.size()];
        for (int i = 0; i < resultBytes.size(); ++i) {
            stringBytes[i] = (Byte)resultBytes.get(i);
        }
        return new String(stringBytes, this.charset);
    }

    @Override
    public int calculateSpan(byte[] data, int offset) {
        for (int i = offset; i < data.length; ++i) {
            if (data[i] != 0) continue;
            return i - offset + 1;
        }
        throw new IllegalArgumentException("Null-terminated character not found");
    }

    @Override
    public int getNoDataSpan() {
        return 1;
    }

    public void setSpan(int span) {
        this.span = span;
    }

    @Override
    public int getSpan() {
        return this.span;
    }

    @Override
    public String bytesToHex(byte[] bytes, int offset) {
        if (bytes == null || bytes.length == 0) {
            throw new IllegalArgumentException("Cannot convert null or empty data to hex.");
        }
        StringBuilder hexBuilder = new StringBuilder();
        for (int i = offset; i < bytes.length; ++i) {
            hexBuilder.append(String.format("%02X", bytes[i]));
            hexBuilder.append(" ");
            if (bytes[i] == 0) break;
        }
        if (!hexBuilder.isEmpty()) {
            hexBuilder.setLength(hexBuilder.length() - 1);
        }
        return hexBuilder.toString();
    }
}

