/*
 * Decompiled with CFR 0.152.
 */
package net.deanly.structlayout.type.basic;

import net.deanly.structlayout.type.CountableField;
import net.deanly.structlayout.type.FieldBase;

public class UInt32BEField
extends FieldBase<Long>
implements CountableField<Long> {
    public UInt32BEField() {
        super(4, Long.class);
    }

    @Override
    public Long decode(byte[] data, int offset) {
        if (data == null) {
            throw new IllegalArgumentException("Data cannot be null.");
        }
        if (offset < 0 || offset + this.getSpan() > data.length) {
            throw new IllegalArgumentException("Invalid offset or insufficient data length.");
        }
        long result = 0L;
        for (int i = 0; i < this.getSpan(); ++i) {
            result = result << 8 | (long)(data[offset + i] & 0xFF);
        }
        if (result > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Decoded value exceeds allowed range for UInt32.");
        }
        return result;
    }

    @Override
    public byte[] encode(Long value) {
        if (value == null || value < 0L) {
            throw new IllegalArgumentException("Cannot encode negative values for UInt32.");
        }
        byte[] data = new byte[this.getSpan()];
        for (int i = this.getSpan() - 1; i >= 0; --i) {
            data[i] = (byte)(value & 0xFFL);
            value = value >>> 8;
        }
        return data;
    }
}

