/*
 * Decompiled with CFR 0.152.
 */
package net.deanly.structlayout.type.basic;

import net.deanly.structlayout.type.CountableField;
import net.deanly.structlayout.type.FieldBase;

public class UInt32LEField
extends FieldBase<Long>
implements CountableField<Long> {
    public UInt32LEField() {
        super(4, Long.class);
    }

    @Override
    public Long decode(byte[] data, int offset) {
        if (data == null) {
            throw new IllegalArgumentException("Data cannot be null.");
        }
        if (offset < 0 || offset + this.getSpan() > data.length) {
            throw new IllegalArgumentException("Invalid offset or insufficient data length.");
        }
        long result = 0L;
        for (int i = 0; i < this.getSpan(); ++i) {
            result |= (long)(data[offset + i] & 0xFF) << 8 * i;
        }
        if (result > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Decoded value exceeds allowed range for UInt32.");
        }
        return result;
    }

    @Override
    public byte[] encode(Long value) {
        if (value == null) {
            throw new IllegalArgumentException("Value cannot be null.");
        }
        if (value < 0L || value > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Value must be in range 0 to 4294967295.");
        }
        byte[] data = new byte[this.getSpan()];
        for (int i = 0; i < this.getSpan(); ++i) {
            data[i] = (byte)(value >> 8 * i & 0xFFL);
        }
        return data;
    }
}

