/*
 * Decompiled with CFR 0.152.
 */
package net.deanly.structlayout.type.borsh;

import net.deanly.structlayout.type.DynamicSpanField;
import net.deanly.structlayout.type.FieldBase;

public abstract class AbstractBorshOptionField<T, F extends FieldBase<T>>
extends FieldBase<T>
implements DynamicSpanField {
    private final F fieldInstance = this.createField();

    public AbstractBorshOptionField() {
        super(1);
    }

    protected abstract F createField();

    @Override
    public byte[] encode(T value) {
        if (value == null) {
            return new byte[]{0};
        }
        byte[] inner = ((FieldBase)this.fieldInstance).encode(value);
        byte[] result = new byte[1 + inner.length];
        result[0] = 1;
        System.arraycopy(inner, 0, result, 1, inner.length);
        return result;
    }

    @Override
    public T decode(byte[] data, int offset) {
        this.validateLength(data, offset);
        if (data.length <= offset) {
            throw new IllegalArgumentException("Insufficient data for Option tag at offset " + offset);
        }
        byte tag = data[offset];
        if (tag == 0) {
            return null;
        }
        if (tag == 1) {
            return ((FieldBase)this.fieldInstance).decode(data, offset + 1);
        }
        throw new IllegalArgumentException("Invalid Option tag value: " + tag);
    }

    @Override
    public int calculateSpan(byte[] data, int offset) {
        this.validateLength(data, offset);
        byte tag = data[offset];
        if (tag == 0) {
            return 1;
        }
        if (tag == 1) {
            return 1 + ((FieldBase)this.fieldInstance).getSpan();
        }
        throw new IllegalArgumentException("Invalid Option tag value: " + tag);
    }

    @Override
    public int getSpan() {
        throw new UnsupportedOperationException("Borsh Option has variable span.");
    }

    @Override
    public int getNoDataSpan() {
        return 1;
    }
}

