/*
 * Decompiled with CFR 0.152.
 */
package net.deanly.structlayout.type.borsh;

import net.deanly.structlayout.type.FieldBase;

public class BorshBooleanField
extends FieldBase<Boolean> {
    public BorshBooleanField() {
        super(1, Boolean.class);
    }

    @Override
    public Boolean decode(byte[] data, int offset) {
        if (data == null) {
            throw new IllegalArgumentException("Data cannot be null.");
        }
        if (data.length <= offset) {
            throw new IllegalArgumentException("Offset is out of bounds for the given data array.");
        }
        byte value = data[offset];
        if (value == 0) {
            return false;
        }
        if (value == 1) {
            return true;
        }
        throw new IllegalArgumentException("Invalid boolean value: " + value);
    }

    @Override
    public byte[] encode(Boolean value) {
        if (value == null) {
            throw new IllegalArgumentException("Value cannot be null.");
        }
        return new byte[]{(byte)(value != false ? 1 : 0)};
    }

    @Override
    public int getSpan() {
        return 1;
    }
}

