/*
 * Decompiled with CFR 0.152.
 */
package net.deanly.structlayout.type.borsh;

import net.deanly.structlayout.type.CountableField;
import net.deanly.structlayout.type.DynamicSpanField;
import net.deanly.structlayout.type.FieldBase;

public class BorshShortVectorField
extends FieldBase<Integer>
implements DynamicSpanField,
CountableField<Integer> {
    private int dynamicSpan;

    public BorshShortVectorField() {
        super(0, Integer.class);
    }

    @Override
    public byte[] encode(Integer value) {
        if (value == null) {
            throw new IllegalArgumentException("Value cannot be null for VLE encoding.");
        }
        byte[] encoded = this.encodeLength(value);
        this.dynamicSpan = encoded.length;
        return encoded;
    }

    @Override
    public Integer decode(byte[] bytes, int offset) {
        int byteCount;
        if (bytes == null) {
            throw new IllegalArgumentException("Data cannot be null for VLE decoding.");
        }
        if (offset < 0 || offset >= bytes.length) {
            throw new IllegalArgumentException("Invalid offset for VLE decoding.");
        }
        int length = this.decodeLength(bytes, offset);
        this.dynamicSpan = byteCount = this.calculateEncodedLength(bytes, offset);
        return length;
    }

    private int calculateEncodedLength(byte[] bytes, int offset) {
        int span = 0;
        while (offset + span < bytes.length) {
            if ((bytes[offset + span] & 0x80) == 0) {
                ++span;
                break;
            }
            ++span;
        }
        return span;
    }

    @Override
    public int calculateSpan(byte[] data, int offset) {
        if (data == null) {
            throw new IllegalArgumentException("Data cannot be null for span calculation.");
        }
        if (offset < 0 || offset >= data.length) {
            throw new IllegalArgumentException("Invalid offset for span calculation.");
        }
        return this.calculateEncodedLength(data, offset);
    }

    @Override
    public int getNoDataSpan() {
        return this.encodeLength(0).length;
    }

    @Override
    public int getSpan() {
        return this.dynamicSpan;
    }

    private byte[] encodeLength(int length) {
        byte[] buffer = new byte[5];
        int i = 0;
        while (length > 127) {
            buffer[i++] = (byte)(length & 0x7F | 0x80);
            length >>>= 7;
        }
        buffer[i++] = (byte)(length & 0x7F);
        byte[] result = new byte[i];
        System.arraycopy(buffer, 0, result, 0, i);
        return result;
    }

    private int decodeLength(byte[] bytes, int offset) {
        int length = 0;
        int shift = 0;
        for (int i = offset; i < bytes.length; ++i) {
            byte b = bytes[i];
            length |= (b & 0x7F) << shift;
            if ((b & 0x80) == 0) break;
            shift += 7;
        }
        return length;
    }
}

