/*
 * Decompiled with CFR 0.152.
 */
package net.deanly.structlayout.type.borsh;

import java.nio.charset.StandardCharsets;
import net.deanly.structlayout.type.DynamicSpanField;
import net.deanly.structlayout.type.FieldBase;

public class BorshStringField
extends FieldBase<String>
implements DynamicSpanField {
    public BorshStringField() {
        super(-1, String.class);
    }

    @Override
    public String decode(byte[] data, int offset) {
        if (data == null) {
            throw new IllegalArgumentException("Data cannot be null.");
        }
        if (offset < 0 || offset + 4 > data.length) {
            throw new IllegalArgumentException("Offset out of bounds. offset=" + offset + ", data.length=" + data.length);
        }
        int length = data[offset] & 0xFF | (data[offset + 1] & 0xFF) << 8 | (data[offset + 2] & 0xFF) << 16 | (data[offset + 3] & 0xFF) << 24;
        if (length < 0 || length > data.length - (offset += 4)) {
            throw new IllegalArgumentException(String.format("Invalid string length in Borsh decoding. length=%d, offset(after header)=%d, data.length=%d, headerOffset=%d", length, offset, data.length, offset - 4));
        }
        if (length == 0) {
            return "";
        }
        return new String(data, offset, length, StandardCharsets.UTF_8).replaceAll("\u0000+$", "");
    }

    @Override
    public byte[] encode(String value) {
        if (value == null) {
            throw new IllegalArgumentException("String value cannot be null");
        }
        byte[] stringBytes = value.getBytes(StandardCharsets.UTF_8);
        int length = stringBytes.length;
        byte[] result = new byte[4 + length];
        result[0] = (byte)(length & 0xFF);
        result[1] = (byte)(length >> 8 & 0xFF);
        result[2] = (byte)(length >> 16 & 0xFF);
        result[3] = (byte)(length >> 24 & 0xFF);
        System.arraycopy(stringBytes, 0, result, 4, length);
        return result;
    }

    @Override
    public int getSpan() {
        throw new UnsupportedOperationException("DynamicStringField requires data to calculate span.");
    }

    @Override
    public int calculateSpan(byte[] data, int offset) {
        int length = data[offset] & 0xFF | (data[offset + 1] & 0xFF) << 8 | (data[offset + 2] & 0xFF) << 16 | (data[offset + 3] & 0xFF) << 24;
        return 4 + length;
    }

    @Override
    public int getNoDataSpan() {
        return 4;
    }
}

