/*
 * Decompiled with CFR 0.152.
 */
package net.deanly.structlayout.type.guava;

import java.math.BigDecimal;
import java.math.BigInteger;
import net.deanly.structlayout.type.guava.UnsignedLongs;

public final class UnsignedLong
extends Number
implements Comparable<UnsignedLong> {
    private static final long UNSIGNED_MASK = Long.MAX_VALUE;
    private static final int CACHE_SIZE = 2048;
    private static final UnsignedLong[] CACHE = new UnsignedLong[2048];
    public static final UnsignedLong ZERO;
    public static final UnsignedLong ONE;
    public static final UnsignedLong MAX_VALUE;
    private final long value;

    UnsignedLong(long value) {
        this.value = value;
    }

    public static UnsignedLong fromLongBits(long bits) {
        if (bits >= 0L && bits < 2048L) {
            return CACHE[(int)bits];
        }
        return new UnsignedLong(bits);
    }

    public static UnsignedLong valueOf(long value) {
        UnsignedLong.checkArgument(value >= 0L, value);
        return UnsignedLong.fromLongBits(value);
    }

    public static UnsignedLong valueOf(BigInteger value) {
        UnsignedLong.checkNotNull(value);
        UnsignedLong.checkArgument(value.signum() >= 0 && value.bitLength() <= 64, value);
        return UnsignedLong.fromLongBits(value.longValue());
    }

    public static UnsignedLong valueOf(String string) {
        return UnsignedLong.valueOf(string, 10);
    }

    public static UnsignedLong valueOf(String string, int radix) {
        return UnsignedLong.fromLongBits(UnsignedLongs.parseUnsignedLong(string, radix));
    }

    public UnsignedLong plus(UnsignedLong val) {
        return UnsignedLong.fromLongBits(this.value + UnsignedLong.checkNotNull(val).value);
    }

    public UnsignedLong minus(UnsignedLong val) {
        return UnsignedLong.fromLongBits(this.value - UnsignedLong.checkNotNull(val).value);
    }

    public UnsignedLong multiply(UnsignedLong val) {
        return UnsignedLong.fromLongBits(this.value * UnsignedLong.checkNotNull(val).value);
    }

    public UnsignedLong divide(UnsignedLong val) {
        return UnsignedLong.fromLongBits(UnsignedLongs.divide(this.value, UnsignedLong.checkNotNull(val).value));
    }

    public UnsignedLong mod(UnsignedLong val) {
        return UnsignedLong.fromLongBits(UnsignedLongs.remainder(this.value, UnsignedLong.checkNotNull(val).value));
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        if (this.value >= 0L) {
            return this.value;
        }
        return (float)(this.value >>> 1 | this.value & 1L) * 2.0f;
    }

    @Override
    public double doubleValue() {
        if (this.value >= 0L) {
            return this.value;
        }
        return (double)(this.value >>> 1 | this.value & 1L) * 2.0;
    }

    public BigInteger bigIntegerValue() {
        BigInteger bigInt = BigInteger.valueOf(this.value & Long.MAX_VALUE);
        if (this.value < 0L) {
            bigInt = bigInt.setBit(63);
        }
        return bigInt;
    }

    public BigInteger toBigInteger() {
        return this.bigIntegerValue();
    }

    public BigDecimal toBigDecimal() {
        return new BigDecimal(this.bigIntegerValue());
    }

    @Override
    public int compareTo(UnsignedLong o) {
        UnsignedLong.checkNotNull(o);
        return UnsignedLongs.compare(this.value, o.value);
    }

    public int hashCode() {
        return Long.hashCode(this.value);
    }

    public boolean equals(Object obj) {
        if (obj instanceof UnsignedLong) {
            UnsignedLong other = (UnsignedLong)obj;
            return this.value == other.value;
        }
        return false;
    }

    public String toString() {
        return UnsignedLongs.toString(this.value);
    }

    public String toString(int radix) {
        return UnsignedLongs.toString(this.value, radix);
    }

    private static void checkArgument(boolean condition, Object ... errorMessageArgs) {
        if (!condition) {
            throw new IllegalArgumentException(String.format("value (%s) is outside the range for an unsigned long value", errorMessageArgs));
        }
    }

    private static <T> T checkNotNull(T reference) {
        if (reference == null) {
            throw new NullPointerException("Reference is null.");
        }
        return reference;
    }

    public boolean isGreaterThan(UnsignedLong other) {
        UnsignedLong.checkNotNull(other);
        return this.compareTo(other) > 0;
    }

    public boolean isGreaterThanOrEqualTo(UnsignedLong other) {
        UnsignedLong.checkNotNull(other);
        return this.compareTo(other) >= 0;
    }

    public boolean isLessThan(UnsignedLong other) {
        UnsignedLong.checkNotNull(other);
        return this.compareTo(other) < 0;
    }

    public boolean isLessThanOrEqualTo(UnsignedLong other) {
        UnsignedLong.checkNotNull(other);
        return this.compareTo(other) <= 0;
    }

    public boolean hasEqualAmount(UnsignedLong other) {
        UnsignedLong.checkNotNull(other);
        return this.equals(other);
    }

    public boolean isZero() {
        return this.equals(ZERO);
    }

    static {
        MAX_VALUE = new UnsignedLong(-1L);
        for (int i = 0; i < 2048; ++i) {
            UnsignedLong.CACHE[i] = new UnsignedLong(i);
        }
        ZERO = CACHE[0];
        ONE = CACHE[1];
    }
}

