/*
 * Decompiled with CFR 0.152.
 */
package net.deanly.structlayout.type.guava;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.Comparator;

public final class UnsignedLongs {
    public static final long MAX_VALUE = -1L;

    private UnsignedLongs() {
    }

    private static long flip(long a) {
        return a ^ Long.MIN_VALUE;
    }

    public static int compare(long a, long b) {
        return Long.compare(UnsignedLongs.flip(a), UnsignedLongs.flip(b));
    }

    public static long min(long ... array) {
        UnsignedLongs.checkArgument(array.length > 0, "array is empty", new Object[0]);
        long min = UnsignedLongs.flip(array[0]);
        for (int i = 1; i < array.length; ++i) {
            long next = UnsignedLongs.flip(array[i]);
            if (next >= min) continue;
            min = next;
        }
        return UnsignedLongs.flip(min);
    }

    public static long max(long ... array) {
        UnsignedLongs.checkArgument(array.length > 0, "array is empty", new Object[0]);
        long max = UnsignedLongs.flip(array[0]);
        for (int i = 1; i < array.length; ++i) {
            long next = UnsignedLongs.flip(array[i]);
            if (next <= max) continue;
            max = next;
        }
        return UnsignedLongs.flip(max);
    }

    public static String join(String separator, long ... array) {
        UnsignedLongs.checkNotNull(separator);
        if (array.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder(array.length * 5);
        builder.append(UnsignedLongs.toString(array[0]));
        for (int i = 1; i < array.length; ++i) {
            builder.append(separator).append(UnsignedLongs.toString(array[i]));
        }
        return builder.toString();
    }

    public static Comparator<long[]> lexicographicalComparator() {
        return LexicographicalComparator.INSTANCE;
    }

    public static void sort(long[] array) {
        UnsignedLongs.checkNotNull(array);
        UnsignedLongs.sort(array, 0, array.length);
    }

    public static void sort(long[] array, int fromIndex, int toIndex) {
        int i;
        UnsignedLongs.checkNotNull(array);
        UnsignedLongs.checkPositionIndexes(fromIndex, toIndex, array.length);
        for (i = fromIndex; i < toIndex; ++i) {
            array[i] = UnsignedLongs.flip(array[i]);
        }
        Arrays.sort(array, fromIndex, toIndex);
        for (i = fromIndex; i < toIndex; ++i) {
            array[i] = UnsignedLongs.flip(array[i]);
        }
    }

    public static void sortDescending(long[] array) {
        UnsignedLongs.checkNotNull(array);
        UnsignedLongs.sortDescending(array, 0, array.length);
    }

    public static void sortDescending(long[] array, int fromIndex, int toIndex) {
        UnsignedLongs.checkNotNull(array);
        UnsignedLongs.checkPositionIndexes(fromIndex, toIndex, array.length);
        int i = fromIndex;
        while (i < toIndex) {
            int n = i++;
            array[n] = array[n] ^ Long.MAX_VALUE;
        }
        Arrays.sort(array, fromIndex, toIndex);
        i = fromIndex;
        while (i < toIndex) {
            int n = i++;
            array[n] = array[n] ^ Long.MAX_VALUE;
        }
    }

    public static long divide(long dividend, long divisor) {
        long quotient;
        if (divisor < 0L) {
            if (UnsignedLongs.compare(dividend, divisor) < 0) {
                return 0L;
            }
            return 1L;
        }
        if (dividend >= 0L) {
            return dividend / divisor;
        }
        long rem = dividend - (quotient = (dividend >>> 1) / divisor << 1) * divisor;
        return quotient + (long)(UnsignedLongs.compare(rem, divisor) >= 0 ? 1 : 0);
    }

    public static long remainder(long dividend, long divisor) {
        long rem;
        if (divisor < 0L) {
            if (UnsignedLongs.compare(dividend, divisor) < 0) {
                return dividend;
            }
            return dividend - divisor;
        }
        if (dividend >= 0L) {
            return dividend % divisor;
        }
        long quotient = (dividend >>> 1) / divisor << 1;
        return rem - (UnsignedLongs.compare(rem = dividend - quotient * divisor, divisor) >= 0 ? divisor : 0L);
    }

    public static long parseUnsignedLong(String string) {
        return UnsignedLongs.parseUnsignedLong(string, 10);
    }

    public static long parseUnsignedLong(String string, int radix) {
        UnsignedLongs.checkNotNull(string);
        if (string.isEmpty()) {
            throw new NumberFormatException("empty string");
        }
        if (radix < 2 || radix > 36) {
            throw new NumberFormatException("illegal radix: " + radix);
        }
        int maxSafePos = ParseOverflowDetection.maxSafeDigits[radix] - 1;
        long value = 0L;
        for (int pos = 0; pos < string.length(); ++pos) {
            int digit = Character.digit(string.charAt(pos), radix);
            if (digit == -1) {
                throw new NumberFormatException(string);
            }
            if (pos > maxSafePos && ParseOverflowDetection.overflowInParse(value, digit, radix)) {
                throw new NumberFormatException("Too large for unsigned long: " + string);
            }
            value = value * (long)radix + (long)digit;
        }
        return value;
    }

    public static long decode(String stringValue) {
        ParseRequest request = ParseRequest.fromString(stringValue);
        try {
            return UnsignedLongs.parseUnsignedLong(request.rawValue, request.radix);
        }
        catch (NumberFormatException e) {
            NumberFormatException decodeException = new NumberFormatException("Error parsing value: " + stringValue);
            decodeException.initCause(e);
            throw decodeException;
        }
    }

    public static String toString(long x) {
        return UnsignedLongs.toString(x, 10);
    }

    public static String toString(long x, int radix) {
        UnsignedLongs.checkArgument(radix >= 2 && radix <= 36, "radix (%s) must be between Character.MIN_RADIX and Character.MAX_RADIX", radix);
        if (x == 0L) {
            return "0";
        }
        if (x > 0L) {
            return Long.toString(x, radix);
        }
        char[] buf = new char[64];
        int i = buf.length;
        if ((radix & radix - 1) == 0) {
            int shift = Integer.numberOfTrailingZeros(radix);
            int mask = radix - 1;
            do {
                buf[--i] = Character.forDigit((int)x & mask, radix);
            } while ((x >>>= shift) != 0L);
        } else {
            long quotient = (radix & 1) == 0 ? (x >>> 1) / (long)(radix >>> 1) : UnsignedLongs.divide(x, radix);
            long rem = x - quotient * (long)radix;
            buf[--i] = Character.forDigit((int)rem, radix);
            for (x = quotient; x > 0L; x /= (long)radix) {
                buf[--i] = Character.forDigit((int)(x % (long)radix), radix);
            }
        }
        return new String(buf, i, buf.length - i);
    }

    private static void checkArgument(boolean condition, String errorMessage, Object ... errorMessageArgs) {
        if (!condition) {
            throw new IllegalArgumentException(String.format(errorMessage, errorMessageArgs));
        }
    }

    private static <T> void checkNotNull(T reference) {
        if (reference == null) {
            throw new NullPointerException("Reference is null.");
        }
    }

    private static void checkPositionIndexes(int fromIndex, int toIndex, int size) {
        if (fromIndex < 0 || toIndex < fromIndex || toIndex > size) {
            throw new IndexOutOfBoundsException(UnsignedLongs.formatPositionIndexesMessage(fromIndex, toIndex, size));
        }
    }

    private static String formatPositionIndexesMessage(int fromIndex, int toIndex, int size) {
        if (fromIndex < 0 || fromIndex > size) {
            return String.format("fromIndex (%d) must be in range [0, %d]", fromIndex, size);
        }
        if (toIndex < 0 || toIndex > size) {
            return String.format("toIndex (%d) must be in range [0, %d]", toIndex, size);
        }
        return String.format("fromIndex (%d) must not be greater than toIndex (%d)", fromIndex, toIndex);
    }

    static enum LexicographicalComparator implements Comparator<long[]>
    {
        INSTANCE;


        @Override
        public int compare(long[] left, long[] right) {
            int minLength = Math.min(left.length, right.length);
            for (int i = 0; i < minLength; ++i) {
                if (left[i] == right[i]) continue;
                return UnsignedLongs.compare(left[i], right[i]);
            }
            return left.length - right.length;
        }

        public String toString() {
            return "UnsignedLongs.lexicographicalComparator()";
        }
    }

    private static final class ParseOverflowDetection {
        static final long[] maxValueDivs = new long[37];
        static final int[] maxValueMods = new int[37];
        static final int[] maxSafeDigits = new int[37];

        private ParseOverflowDetection() {
        }

        static boolean overflowInParse(long current, int digit, int radix) {
            if (current >= 0L) {
                if (current < maxValueDivs[radix]) {
                    return false;
                }
                if (current > maxValueDivs[radix]) {
                    return true;
                }
                return digit > maxValueMods[radix];
            }
            return true;
        }

        static {
            BigInteger overflow = new BigInteger("10000000000000000", 16);
            for (int i = 2; i <= 36; ++i) {
                ParseOverflowDetection.maxValueDivs[i] = UnsignedLongs.divide(-1L, i);
                ParseOverflowDetection.maxValueMods[i] = (int)UnsignedLongs.remainder(-1L, i);
                ParseOverflowDetection.maxSafeDigits[i] = overflow.toString(i).length() - 1;
            }
        }
    }

    private static final class ParseRequest {
        final String rawValue;
        final int radix;

        private ParseRequest(String rawValue, int radix) {
            this.rawValue = rawValue;
            this.radix = radix;
        }

        static ParseRequest fromString(String stringValue) {
            int radix;
            String rawValue;
            if (stringValue.isEmpty()) {
                throw new NumberFormatException("empty string");
            }
            char firstChar = stringValue.charAt(0);
            if (stringValue.startsWith("0x") || stringValue.startsWith("0X")) {
                rawValue = stringValue.substring(2);
                radix = 16;
            } else if (firstChar == '#') {
                rawValue = stringValue.substring(1);
                radix = 16;
            } else if (firstChar == '0' && stringValue.length() > 1) {
                rawValue = stringValue.substring(1);
                radix = 8;
            } else {
                rawValue = stringValue;
                radix = 10;
            }
            return new ParseRequest(rawValue, radix);
        }
    }
}

