/*
 * Decompiled with CFR 0.152.
 */
package net.deanly.structlayout.type.rust;

import net.deanly.structlayout.type.DynamicSpanField;
import net.deanly.structlayout.type.FieldBase;

public abstract class AbstractRustCOptionField<T, F extends FieldBase<T>>
extends FieldBase<T>
implements DynamicSpanField {
    private static final byte[] NONE_TAG = new byte[]{0, 0, 0, 0};
    private static final byte[] SOME_TAG = new byte[]{1, 0, 0, 0};
    private final F fieldInstance = this.createField();

    public AbstractRustCOptionField() {
        super(4);
    }

    protected abstract F createField();

    @Override
    public byte[] encode(T value) {
        byte[] result;
        if (value == null) {
            byte[] zero = new byte[((FieldBase)this.fieldInstance).getSpan()];
            result = new byte[4 + zero.length];
            System.arraycopy(NONE_TAG, 0, result, 0, 4);
            System.arraycopy(zero, 0, result, 4, zero.length);
        } else {
            byte[] inner = ((FieldBase)this.fieldInstance).encode(value);
            result = new byte[4 + inner.length];
            System.arraycopy(SOME_TAG, 0, result, 0, 4);
            System.arraycopy(inner, 0, result, 4, inner.length);
        }
        return result;
    }

    @Override
    public T decode(byte[] data, int offset) {
        boolean isSome;
        this.validateLength(data, offset);
        if (data.length - offset < 4) {
            throw new IllegalArgumentException("Data too short to read COption tag.");
        }
        boolean bl = isSome = data[offset] == 1 && data[offset + 1] == 0 && data[offset + 2] == 0 && data[offset + 3] == 0;
        if (!(isSome || data[offset] == 0 && data[offset + 1] == 0 && data[offset + 2] == 0 && data[offset + 3] == 0)) {
            throw new IllegalArgumentException("Invalid COption tag at offset " + offset);
        }
        return isSome ? (T)((FieldBase)this.fieldInstance).decode(data, offset + 4) : null;
    }

    @Override
    public int calculateSpan(byte[] data, int offset) {
        this.validateLength(data, offset);
        return 4 + ((FieldBase)this.fieldInstance).getSpan();
    }

    @Override
    public int getSpan() {
        return 4 + ((FieldBase)this.fieldInstance).getSpan();
    }

    @Override
    public int getNoDataSpan() {
        return 4 + ((FieldBase)this.fieldInstance).getSpan();
    }
}

