/*
 * Decompiled with CFR 0.152.
 */
package com.redis.cluster;

import com.redis.cluster.HashRing$;
import java.io.Serializable;
import java.util.zip.CRC32;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.TreeMap;
import scala.collection.immutable.TreeMap$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005]h\u0001\u0002\u0013&\u00012B\u0001B\u000f\u0001\u0003\u0016\u0004%\ta\u000f\u0005\t'\u0002\u0011\t\u0012)A\u0005y!AA\u000b\u0001BK\u0002\u0013\u0005Q\u000b\u0003\u0005Z\u0001\tE\t\u0015!\u0003W\u0011\u0015Q\u0006\u0001\"\u0001\\\u0011\u001d1\u0003A1A\u0005\u0002\u0001Da!\u001b\u0001!\u0002\u0013\t\u0007b\u00026\u0001\u0001\u0004%Ia\u001b\u0005\bk\u0002\u0001\r\u0011\"\u0003w\u0011\u0019a\b\u0001)Q\u0005Y\")Q\u0010\u0001C\u0001}\"9\u00111\u0001\u0001\u0005\u0002\u0005\u0015\u0001bBA\b\u0001\u0011\u0005\u0011\u0011\u0003\u0005\b\u0003+\u0001A\u0011AA\f\u0011\u001d\tI\u0003\u0001C\u0001\u0003WAq!!\r\u0001\t\u0003\t\u0019\u0004C\u0004\u0002<\u0001!I!!\u0010\t\u0013\u0005\u0015\u0003!!A\u0005\u0002\u0005\u001d\u0003\"CA,\u0001E\u0005I\u0011AA-\u0011%\t\u0019\bAI\u0001\n\u0003\t)\bC\u0005\u0002~\u0001\t\t\u0011\"\u0011\u0002\u0000!A\u0011\u0011\u0013\u0001\u0002\u0002\u0013\u0005Q\u000bC\u0005\u0002\u0014\u0002\t\t\u0011\"\u0001\u0002\u0016\"I\u0011\u0011\u0014\u0001\u0002\u0002\u0013\u0005\u00131\u0014\u0005\n\u0003K\u0003\u0011\u0011!C\u0001\u0003OC\u0011\"a+\u0001\u0003\u0003%\t%!,\t\u0013\u0005=\u0006!!A\u0005B\u0005E\u0006\"CAZ\u0001\u0005\u0005I\u0011IA[\u000f%\tI,JA\u0001\u0012\u0003\tYL\u0002\u0005%K\u0005\u0005\t\u0012AA_\u0011\u0019Qf\u0004\"\u0001\u0002@\"I\u0011q\u0016\u0010\u0002\u0002\u0013\u0015\u0013\u0011\u0017\u0005\n\u0003\u0003t\u0012\u0011!CA\u0003\u0007D\u0011\"a5\u001f\u0003\u0003%\t)!6\t\u0013\u00055h$!A\u0005\n\u0005=(\u0001\u0003%bg\"\u0014\u0016N\\4\u000b\u0005\u0019:\u0013aB2mkN$XM\u001d\u0006\u0003Q%\nQA]3eSNT\u0011AK\u0001\u0004G>l7\u0001A\u000b\u0003[)\u001bB\u0001\u0001\u00185oA\u0011qFM\u0007\u0002a)\t\u0011'A\u0003tG\u0006d\u0017-\u0003\u00024a\t1\u0011I\\=SK\u001a\u0004\"aL\u001b\n\u0005Y\u0002$a\u0002)s_\u0012,8\r\u001e\t\u0003_aJ!!\u000f\u0019\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u000b9|G-Z:\u0016\u0003q\u00022!P#I\u001d\tq4I\u0004\u0002@\u00056\t\u0001I\u0003\u0002BW\u00051AH]8pizJ\u0011!M\u0005\u0003\tB\nq\u0001]1dW\u0006<W-\u0003\u0002G\u000f\n!A*[:u\u0015\t!\u0005\u0007\u0005\u0002J\u00152\u0001A!B&\u0001\u0005\u0004a%!\u0001+\u0012\u00055\u0003\u0006CA\u0018O\u0013\ty\u0005GA\u0004O_RD\u0017N\\4\u0011\u0005=\n\u0016B\u0001*1\u0005\r\te._\u0001\u0007]>$Wm\u001d\u0011\u0002\u0011I,\u0007\u000f\\5dCN,\u0012A\u0016\t\u0003_]K!\u0001\u0017\u0019\u0003\u0007%sG/A\u0005sKBd\u0017nY1tA\u00051A(\u001b8jiz\"2\u0001\u00180`!\ri\u0006\u0001S\u0007\u0002K!)!(\u0002a\u0001y!)A+\u0002a\u0001-V\t\u0011\rE\u0002cO\"k\u0011a\u0019\u0006\u0003I\u0016\fq!\\;uC\ndWM\u0003\u0002ga\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005!\u001c'aC!se\u0006L()\u001e4gKJ\f\u0001b\u00197vgR,'\u000fI\u0001\u0005e&tw-F\u0001m!\u0011i\u0007O\u001d%\u000e\u00039T!a\\3\u0002\u0013%lW.\u001e;bE2,\u0017BA9o\u0005\u001d!&/Z3NCB\u0004\"aL:\n\u0005Q\u0004$\u0001\u0002'p]\u001e\f\u0001B]5oO~#S-\u001d\u000b\u0003oj\u0004\"a\f=\n\u0005e\u0004$\u0001B+oSRDqa_\u0005\u0002\u0002\u0003\u0007A.A\u0002yIE\nQA]5oO\u0002\nq!\u00193e\u001d>$W\r\u0006\u0002x\u007f\"1\u0011\u0011A\u0006A\u0002!\u000bAA\\8eK\u0006Y!/\u001a9mC\u000e,gj\u001c3f)\u0011\t9!!\u0004\u0011\t=\nI\u0001S\u0005\u0004\u0003\u0017\u0001$AB(qi&|g\u000e\u0003\u0004\u0002\u00021\u0001\r\u0001S\u0001\u000be\u0016lwN^3O_\u0012,GcA<\u0002\u0014!1\u0011\u0011A\u0007A\u0002!\u000bqaZ3u\u001d>$W\rF\u0002I\u00033Aq!a\u0007\u000f\u0001\u0004\ti\"A\u0002lKf\u0004R!PA\u0010\u0003GI1!!\tH\u0005\r\u0019V-\u001d\t\u0004_\u0005\u0015\u0012bAA\u0014a\t!!)\u001f;f\u0003E\u0019\u0017\r\\2vY\u0006$Xm\u00115fG.\u001cX/\u001c\u000b\u0004e\u00065\u0002bBA\u0018\u001f\u0001\u0007\u0011QD\u0001\u0006m\u0006dW/Z\u0001\bSN,U\u000e\u001d;z+\t\t)\u0004E\u00020\u0003oI1!!\u000f1\u0005\u001d\u0011un\u001c7fC:\f1B\\8eK\"\u000b7\u000f\u001b$peR)!/a\u0010\u0002B!1\u0011\u0011A\tA\u0002!Ca!a\u0011\u0012\u0001\u00041\u0016a\u0002:fa2L7-Y\u0001\u0005G>\u0004\u00180\u0006\u0003\u0002J\u0005=CCBA&\u0003#\n)\u0006\u0005\u0003^\u0001\u00055\u0003cA%\u0002P\u0011)1J\u0005b\u0001\u0019\"A!H\u0005I\u0001\u0002\u0004\t\u0019\u0006\u0005\u0003>\u000b\u00065\u0003b\u0002+\u0013!\u0003\u0005\rAV\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\u0011\tY&!\u001d\u0016\u0005\u0005u#f\u0001\u001f\u0002`-\u0012\u0011\u0011\r\t\u0005\u0003G\ni'\u0004\u0002\u0002f)!\u0011qMA5\u0003%)hn\u00195fG.,GMC\u0002\u0002lA\n!\"\u00198o_R\fG/[8o\u0013\u0011\ty'!\u001a\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rB\u0003L'\t\u0007A*\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\t\u0005]\u00141P\u000b\u0003\u0003sR3AVA0\t\u0015YEC1\u0001M\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011\u0011\u0011\t\u0005\u0003\u0007\u000bi)\u0004\u0002\u0002\u0006*!\u0011qQAE\u0003\u0011a\u0017M\\4\u000b\u0005\u0005-\u0015\u0001\u00026bm\u0006LA!a$\u0002\u0006\n11\u000b\u001e:j]\u001e\fA\u0002\u001d:pIV\u001cG/\u0011:jif\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000fF\u0002Q\u0003/Cqa_\f\u0002\u0002\u0003\u0007a+A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\ti\nE\u0003\u0002 \u0006\u0005\u0006+D\u0001f\u0013\r\t\u0019+\u001a\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u00026\u0005%\u0006bB>\u001a\u0003\u0003\u0005\r\u0001U\u0001\tQ\u0006\u001c\bnQ8eKR\ta+\u0001\u0005u_N#(/\u001b8h)\t\t\t)\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003k\t9\fC\u0004|9\u0005\u0005\t\u0019\u0001)\u0002\u0011!\u000b7\u000f\u001b*j]\u001e\u0004\"!\u0018\u0010\u0014\u0007yqs\u0007\u0006\u0002\u0002<\u0006)\u0011\r\u001d9msV!\u0011QYAf)\u0019\t9-!4\u0002RB!Q\fAAe!\rI\u00151\u001a\u0003\u0006\u0017\u0006\u0012\r\u0001\u0014\u0005\u0007u\u0005\u0002\r!a4\u0011\tu*\u0015\u0011\u001a\u0005\u0006)\u0006\u0002\rAV\u0001\bk:\f\u0007\u000f\u001d7z+\u0011\t9.!:\u0015\t\u0005e\u0017q\u001d\t\u0006_\u0005%\u00111\u001c\t\u0007_\u0005u\u0017\u0011\u001d,\n\u0007\u0005}\u0007G\u0001\u0004UkBdWM\r\t\u0005{\u0015\u000b\u0019\u000fE\u0002J\u0003K$Qa\u0013\u0012C\u00021C\u0011\"!;#\u0003\u0003\u0005\r!a;\u0002\u0007a$\u0003\u0007\u0005\u0003^\u0001\u0005\r\u0018a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!!=\u0011\t\u0005\r\u00151_\u0005\u0005\u0003k\f)I\u0001\u0004PE*,7\r\u001e")
public class HashRing<T>
implements Product,
scala.Serializable {
    private final List<T> nodes;
    private final int replicas;
    private final ArrayBuffer<T> cluster;
    private TreeMap<Object, T> ring;

    public static <T> Option<Tuple2<List<T>, Object>> unapply(HashRing<T> hashRing) {
        return HashRing$.MODULE$.unapply(hashRing);
    }

    public static <T> HashRing<T> apply(List<T> list, int n) {
        return HashRing$.MODULE$.apply(list, n);
    }

    public List<T> nodes() {
        return this.nodes;
    }

    public int replicas() {
        return this.replicas;
    }

    public ArrayBuffer<T> cluster() {
        return this.cluster;
    }

    private TreeMap<Object, T> ring() {
        return this.ring;
    }

    private void ring_$eq(TreeMap<Object, T> x$1) {
        this.ring = x$1;
    }

    public void addNode(T node) {
        this.cluster().$plus$eq(node);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.replicas()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)replica -> this.ring_$eq(this.ring().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)this.nodeHashFor(node, replica))), node))));
    }

    public Option<T> replaceNode(T node) {
        ObjectRef replacedNode = ObjectRef.create((Object)None$.MODULE$);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.cluster().size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            block0: {
                if (!this.cluster().apply(i).toString().equals(node.toString())) break block0;
                replacedNode$1.elem = new Some(this.cluster().apply(i));
                this.cluster().update(i, node);
            }
        });
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.replicas()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)replica -> this.ring_$eq(this.ring().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)this.nodeHashFor(node, replica))), node))));
        return (Option)replacedNode.elem;
    }

    public void removeNode(T node) {
        this.cluster().$minus$eq(node);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.replicas()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)replica -> this.ring_$eq(this.ring().$minus((Object)BoxesRunTime.boxToLong((long)this.nodeHashFor(node, replica)))));
    }

    public T getNode(Seq<Object> key) {
        if (this.isEmpty()) {
            throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("Can't get node for [%s] from an empty ring")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key})));
        }
        long crc = this.calculateChecksum(key);
        return (T)this.ring().getOrElse((Object)BoxesRunTime.boxToLong((long)crc), (Function0 & Serializable & scala.Serializable)() -> this.nextClockwise$1(crc));
    }

    public long calculateChecksum(Seq<Object> value) {
        CRC32 checksum = new CRC32();
        checksum.update((byte[])value.toArray(ClassTag$.MODULE$.Byte()));
        return checksum.getValue();
    }

    public boolean isEmpty() {
        return this.ring().isEmpty();
    }

    private long nodeHashFor(T node, int replica) {
        return this.calculateChecksum((Seq<Object>)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(new StringBuilder(1).append(node).append(":").append(replica).toString().getBytes("UTF-8"))).toIndexedSeq());
    }

    public <T> HashRing<T> copy(List<T> nodes, int replicas) {
        return new HashRing<T>(nodes, replicas);
    }

    public <T> List<T> copy$default$1() {
        return this.nodes();
    }

    public <T> int copy$default$2() {
        return this.replicas();
    }

    public String productPrefix() {
        return "HashRing";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.nodes();
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToInteger((int)this.replicas());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof HashRing;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)Statics.anyHash(this.nodes()));
        n = Statics.mix((int)n, (int)this.replicas());
        return Statics.finalizeHash((int)n, (int)2);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof HashRing)) return false;
        boolean bl = true;
        if (!bl) return false;
        HashRing hashRing = (HashRing)x$1;
        List<T> list = this.nodes();
        List<T> list2 = hashRing.nodes();
        if (list == null) {
            if (list2 != null) {
                return false;
            }
        } else if (!list.equals(list2)) return false;
        if (this.replicas() != hashRing.replicas()) return false;
        if (!hashRing.canEqual(this)) return false;
        return true;
    }

    private final Object nextClockwise$1(long crc$1) {
        Tuple2 tuple2 = (Tuple2)this.ring().rangeImpl((Option)new Some((Object)BoxesRunTime.boxToLong((long)crc$1)), (Option)None$.MODULE$).headOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> this.ring().head());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        long ringKey = tuple2._1$mcJ$sp();
        Object node = tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)ringKey), node);
        Tuple2 tuple23 = tuple22;
        long ringKey2 = tuple23._1$mcJ$sp();
        Object node2 = tuple23._2();
        return node2;
    }

    public HashRing(List<T> nodes, int replicas) {
        this.nodes = nodes;
        this.replicas = replicas;
        Product.$init$((Product)this);
        this.cluster = new ArrayBuffer();
        this.ring = (TreeMap)TreeMap$.MODULE$.apply((Seq)Nil$.MODULE$, (Ordering)Ordering.Long$.MODULE$);
        nodes.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            this.addNode(x$1);
            return BoxedUnit.UNIT;
        });
    }
}

