package com.redis

object Util {
  object Break extends RuntimeException
  def break: Unit = { throw Break }
  def whileTrue(block: => Unit): Unit = {
    while (true)
      try {
        block
      } catch { case Break => return }
  }
}

sealed trait PubSubMessage
case class S(channel: String, noSubscribed: Int) extends PubSubMessage
case class U(channel: String, noSubscribed: Int) extends PubSubMessage
case class M(origChannel: String, message: String) extends PubSubMessage
case class E(e: java.lang.Throwable) extends PubSubMessage

import Util._
trait PubSub extends PubOperations { self: Redis =>
  var pubSub: Boolean = _

  class Consumer(fn: PubSubMessage => Any) extends Runnable {

    def start (): Unit = {
      val myThread = new Thread(this) ;
      myThread.start() ;
    }

    override def run(): Unit = {
      try {
        whileTrue {
          asList match {
            case Some(Some(msgType) :: Some(channel) :: Some(data) :: Nil) =>
              msgType match {
                case "subscribe" | "psubscribe" => fn(S(channel, data.toInt))
                case "unsubscribe" if (data.toInt == 0) => 
                  fn(U(channel, data.toInt))
                  break
                case "punsubscribe" if (data.toInt == 0) => 
                  fn(U(channel, data.toInt))
                  break
                case "unsubscribe" | "punsubscribe" => 
                  fn(U(channel, data.toInt))
                case "message" =>
                  fn(M(channel, data))
                case x => throw new RuntimeException("unhandled message: " + x)
              }
            case Some(Some(msgType) :: Some(pattern) :: Some(channel) :: List(Some(data))) =>
              msgType match {
                case "pmessage" =>
                  fn(M(channel, data))
                case x => throw new RuntimeException("unhandled message: " + x)
              }
            case _ => break
          }
        }
      } catch {
        case e: Throwable => fn(E(e))
      }
    }
  }

  def pSubscribe(channel: String, channels: String*)(fn: PubSubMessage => Any): Unit = {
    if (pubSub) { // already pubsub ing
      pSubscribeRaw(channel, channels: _*)
      return
    }
    pubSub = true
    pSubscribeRaw(channel, channels: _*)
    new Consumer(fn).start()
  }

  def pSubscribeRaw(channel: String, channels: String*): Unit = {
    send("PSUBSCRIBE", channel :: channels.toList)(())
  }

  def pUnsubscribe(): Unit = {
    send("PUNSUBSCRIBE")(())
  }

  def pUnsubscribe(channel: String, channels: String*): Unit = {
    send("PUNSUBSCRIBE", channel :: channels.toList)(())
  }
  def subscribe(channel: String, channels: String*)(fn: PubSubMessage => Any): Unit = {
    if (pubSub) { // already pubsub ing
      subscribeRaw(channel, channels: _*)
    } else {
      pubSub = true
      subscribeRaw(channel, channels: _*)
      new Consumer(fn).start()
    }
  }

  def subscribeRaw(channel: String, channels: String*): Unit = {
    send("SUBSCRIBE", channel :: channels.toList)(())
  }

  def unsubscribe(): Unit = {
    val r = send("UNSUBSCRIBE")(())
    pubSub = false
    r
  }

  def unsubscribe(channel: String, channels: String*): Unit = {
    val r = send("UNSUBSCRIBE", channel :: channels.toList)(())
    pubSub = false
    r
  }
}

trait PubOperations { self: Redis =>
  def publish(channel: String, msg: String): Option[Long] = {
    send("PUBLISH", List(channel, msg))(asLong)
  }
}
