/*
 * Decompiled with CFR 0.152.
 */
package net.deechael.chschar;

import net.deechael.chschar.Tone;

public enum Finals {
    A("a", "\u0101", "\u00e1", "\u01ce", "\u00e0"),
    O("o", "\u014d", "\u00f3", "\u01d2", "\u00f2"),
    E("e", "\u0113", "\u00e9", "\u011b", "\u00e8"),
    I("i", "\u012b", "\u00ed", "\u01d0", "\u00ec"),
    U("u", "\u016b", "\u00fa", "\u01d4", "\u00f9"),
    V("\u00fc", "\u01d6", "\u01d8", "\u01da", "\u01dc"),
    UNKNOWN("", "", "", "", "");

    private final String character;
    private final String levelChar;
    private final String risingChar;
    private final String fallingRisingChar;
    private final String fallingChar;

    private Finals(String character, String levelChar, String risingChar, String fallingRisingChar, String fallingChar) {
        this.character = character;
        this.levelChar = levelChar;
        this.risingChar = risingChar;
        this.fallingRisingChar = fallingRisingChar;
        this.fallingChar = fallingChar;
    }

    public String getCharacter(Tone tone) {
        switch (tone) {
            case LEVEL: {
                return this.getLevelCharacter();
            }
            case RISING: {
                return this.getRisingCharacter();
            }
            case FALLING_RISING: {
                return this.getFallingRisingCharacter();
            }
            case FALLING: {
                return this.getFallingCharacter();
            }
        }
        return this.getSoftCharacter();
    }

    public String getCharacter() {
        return this.character;
    }

    public String getSoftCharacter() {
        return this.character;
    }

    public String getLevelCharacter() {
        return this.levelChar;
    }

    public String getRisingCharacter() {
        return this.risingChar;
    }

    public String getFallingRisingCharacter() {
        return this.fallingRisingChar;
    }

    public String getFallingCharacter() {
        return this.fallingChar;
    }
}

