/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.client.stubfactory;

import io.grpc.Channel;
import io.grpc.stub.AbstractStub;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import net.devh.boot.grpc.client.stubfactory.StubFactory;
import org.springframework.beans.BeanInstantiationException;

public final class FallbackStubFactory
implements StubFactory {
    @Override
    public boolean isApplicable(Class<? extends AbstractStub<?>> stubType) {
        return true;
    }

    @Override
    public AbstractStub<?> createStub(Class<? extends AbstractStub<?>> stubType, Channel channel) {
        try {
            Class<?> declaringClass = stubType.getDeclaringClass();
            if (declaringClass != null) {
                for (Method method : declaringClass.getMethods()) {
                    String name = method.getName();
                    int modifiers = method.getModifiers();
                    Parameter[] parameters = method.getParameters();
                    if (!name.startsWith("new") || !name.endsWith("Stub") || !Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers) || !method.getReturnType().isAssignableFrom(stubType) || parameters.length != 1 || !Channel.class.equals(parameters[0].getType())) continue;
                    return (AbstractStub)AbstractStub.class.cast(method.invoke(null, channel));
                }
            }
            Constructor<AbstractStub<?>> constructor = stubType.getConstructor(Channel.class);
            return constructor.newInstance(channel);
        }
        catch (Exception e) {
            throw new BeanInstantiationException(stubType, "Failed to create gRPC client via FallbackStubFactory", (Throwable)e);
        }
    }
}

