/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.client.interceptor;

import com.google.common.collect.ImmutableList;
import io.grpc.ClientInterceptor;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.devh.boot.grpc.client.interceptor.GlobalClientInterceptorConfigurer;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;

public class GlobalClientInterceptorRegistry {
    private final ApplicationContext applicationContext;
    private ImmutableList<ClientInterceptor> sortedClientInterceptors;

    public GlobalClientInterceptorRegistry(ApplicationContext applicationContext) {
        this.applicationContext = Objects.requireNonNull(applicationContext, "applicationContext");
    }

    public ImmutableList<ClientInterceptor> getClientInterceptors() {
        if (this.sortedClientInterceptors == null) {
            this.sortedClientInterceptors = ImmutableList.copyOf(this.initClientInterceptors());
        }
        return this.sortedClientInterceptors;
    }

    protected List<ClientInterceptor> initClientInterceptors() {
        ArrayList<ClientInterceptor> interceptors = new ArrayList<ClientInterceptor>();
        for (GlobalClientInterceptorConfigurer configurer : this.applicationContext.getBeansOfType(GlobalClientInterceptorConfigurer.class).values()) {
            configurer.configureClientInterceptors(interceptors);
        }
        this.sortInterceptors(interceptors);
        return interceptors;
    }

    public void sortInterceptors(List<? extends ClientInterceptor> interceptors) {
        interceptors.sort((Comparator<? extends ClientInterceptor>)AnnotationAwareOrderComparator.INSTANCE);
    }
}

