/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.client.channelfactory;

import io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.shaded.io.grpc.netty.NegotiationType;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContextBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import javax.net.ssl.SSLException;
import net.devh.boot.grpc.client.channelfactory.AbstractChannelFactory;
import net.devh.boot.grpc.client.channelfactory.GrpcChannelConfigurer;
import net.devh.boot.grpc.client.config.GrpcChannelProperties;
import net.devh.boot.grpc.client.config.GrpcChannelsProperties;
import net.devh.boot.grpc.client.interceptor.GlobalClientInterceptorRegistry;
import org.springframework.core.io.Resource;

public class ShadedNettyChannelFactory
extends AbstractChannelFactory<NettyChannelBuilder> {
    public ShadedNettyChannelFactory(GrpcChannelsProperties properties, GlobalClientInterceptorRegistry globalClientInterceptorRegistry, List<GrpcChannelConfigurer> channelConfigurers) {
        super(properties, globalClientInterceptorRegistry, channelConfigurers);
    }

    @Override
    protected NettyChannelBuilder newChannelBuilder(String name) {
        GrpcChannelProperties properties = this.getPropertiesFor(name);
        URI address = properties.getAddress();
        if (address == null) {
            address = URI.create(name);
        }
        return (NettyChannelBuilder)NettyChannelBuilder.forTarget((String)address.toString()).defaultLoadBalancingPolicy(properties.getDefaultLoadBalancingPolicy());
    }

    @Override
    protected void configureSecurity(NettyChannelBuilder builder, String name) {
        GrpcChannelProperties properties = this.getPropertiesFor(name);
        net.devh.boot.grpc.client.config.NegotiationType negotiationType = properties.getNegotiationType();
        builder.negotiationType(ShadedNettyChannelFactory.of(negotiationType));
        if (negotiationType == net.devh.boot.grpc.client.config.NegotiationType.TLS) {
            Resource trustCertCollection;
            GrpcChannelProperties.Security security = properties.getSecurity();
            String authorityOverwrite = security.getAuthorityOverride();
            if (authorityOverwrite != null && !authorityOverwrite.isEmpty()) {
                builder.overrideAuthority(authorityOverwrite);
            }
            SslContextBuilder sslContextBuilder = GrpcSslContexts.forClient();
            if (security.isClientAuthEnabled()) {
                Resource certificateChain = Objects.requireNonNull(security.getCertificateChain(), "certificateChain not configured");
                Resource privateKey = Objects.requireNonNull(security.getPrivateKey(), "privateKey not configured");
                try (InputStream certificateChainStream = certificateChain.getInputStream();
                     InputStream privateKeyStream = privateKey.getInputStream();){
                    sslContextBuilder.keyManager(certificateChainStream, privateKeyStream, security.getPrivateKeyPassword());
                }
                catch (IOException | RuntimeException e) {
                    throw new IllegalArgumentException("Failed to create SSLContext (PK/Cert)", e);
                }
            }
            if ((trustCertCollection = security.getTrustCertCollection()) != null) {
                try (InputStream trustCertCollectionStream = trustCertCollection.getInputStream();){
                    sslContextBuilder.trustManager(trustCertCollectionStream);
                }
                catch (IOException | RuntimeException e) {
                    throw new IllegalArgumentException("Failed to create SSLContext (TrustStore)", e);
                }
            }
            if (security.getCiphers() != null && !security.getCiphers().isEmpty()) {
                sslContextBuilder.ciphers(security.getCiphers());
            }
            if (security.getProtocols() != null && security.getProtocols().length > 0) {
                sslContextBuilder.protocols(security.getProtocols());
            }
            try {
                builder.sslContext(sslContextBuilder.build());
            }
            catch (SSLException e) {
                throw new IllegalStateException("Failed to create ssl context for grpc client", e);
            }
        }
    }

    protected static NegotiationType of(net.devh.boot.grpc.client.config.NegotiationType negotiationType) {
        switch (negotiationType) {
            case PLAINTEXT: {
                return NegotiationType.PLAINTEXT;
            }
            case PLAINTEXT_UPGRADE: {
                return NegotiationType.PLAINTEXT_UPGRADE;
            }
            case TLS: {
                return NegotiationType.TLS;
            }
        }
        throw new IllegalArgumentException("Unsupported NegotiationType: " + (Object)((Object)negotiationType));
    }
}

