/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.client.metric;

import io.grpc.ClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Metadata;
import io.grpc.Status;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.util.function.Function;

class MetricCollectingClientCallListener<A>
extends ForwardingClientCallListener.SimpleForwardingClientCallListener<A> {
    private final Timer.Sample timerSample;
    private final Counter responseCounter;
    private final Function<Status.Code, Timer> timerFunction;

    public MetricCollectingClientCallListener(ClientCall.Listener<A> delegate, MeterRegistry registry, Counter responseCounter, Function<Status.Code, Timer> timerFunction) {
        super(delegate);
        this.responseCounter = responseCounter;
        this.timerFunction = timerFunction;
        this.timerSample = Timer.start((MeterRegistry)registry);
    }

    public void onClose(Status status, Metadata metadata) {
        this.timerSample.stop(this.timerFunction.apply(status.getCode()));
        super.onClose(status, metadata);
    }

    public void onMessage(A responseMessage) {
        this.responseCounter.increment();
        super.onMessage(responseMessage);
    }
}

