/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.client.inject;

import jakarta.validation.constraints.NotNull;
import java.lang.reflect.Executable;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import net.devh.boot.grpc.client.inject.GrpcClient;
import net.devh.boot.grpc.client.inject.GrpcClientConstructorInjection;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;

public class GrpcClientConstructorInjectionBeanFactoryPostProcessor
implements BeanFactoryPostProcessor {
    public void postProcessBeanFactory(@NotNull ConfigurableListableBeanFactory beanFactory) throws BeansException {
        GrpcClientConstructorInjection grpcClientConstructorInjection = new GrpcClientConstructorInjection();
        beanFactory.getBeanNamesIterator().forEachRemaining(beanName -> {
            Class clazz = beanFactory.getType(beanName);
            if (clazz == null) {
                return;
            }
            BeanDefinition beanDefinition = null;
            try {
                beanDefinition = beanFactory.getBeanDefinition(beanName);
            }
            catch (NoSuchBeanDefinitionException ignored) {
                return;
            }
            for (Executable constructor : this.getConstructorCandidates(beanFactory, beanDefinition, clazz)) {
                Parameter[] parameters = constructor.getParameters();
                for (int i = 0; i < parameters.length; ++i) {
                    Parameter parameter = parameters[i];
                    GrpcClient client = parameter.getAnnotation(GrpcClient.class);
                    if (client == null) continue;
                    GrpcClientConstructorInjection.Registry registry = new GrpcClientConstructorInjection.Registry(parameter.getType(), client, clazz, beanDefinition, i);
                    grpcClientConstructorInjection.add(registry);
                }
            }
        });
        if (!grpcClientConstructorInjection.isEmpty()) {
            beanFactory.registerSingleton("grpcClientConstructorInjection", (Object)grpcClientConstructorInjection);
        }
    }

    private Executable[] getConstructorCandidates(ConfigurableListableBeanFactory beanFactory, BeanDefinition beanDefinition, Class<?> clazz) {
        if (beanDefinition != null) {
            Class factoryClass;
            String factoryBeanName = beanDefinition.getFactoryBeanName();
            String factoryMethodName = beanDefinition.getFactoryMethodName();
            if (factoryBeanName != null && factoryMethodName != null && (factoryClass = beanFactory.getType(factoryBeanName)) != null) {
                return (Executable[])Arrays.stream(factoryClass.getDeclaredMethods()).filter(m -> factoryMethodName.equals(m.getName())).toArray(Executable[]::new);
            }
        }
        return clazz.getDeclaredConstructors();
    }
}

