/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.server.interceptor;

import com.google.common.collect.ImmutableList;
import io.grpc.ServerInterceptor;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.devh.boot.grpc.common.util.InterceptorOrder;
import net.devh.boot.grpc.server.interceptor.GlobalServerInterceptorConfigurer;
import org.springframework.context.ApplicationContext;

public class GlobalServerInterceptorRegistry {
    private final ApplicationContext applicationContext;
    private ImmutableList<ServerInterceptor> sortedServerInterceptors;

    public GlobalServerInterceptorRegistry(ApplicationContext applicationContext) {
        this.applicationContext = Objects.requireNonNull(applicationContext, "applicationContext");
    }

    public ImmutableList<ServerInterceptor> getServerInterceptors() {
        if (this.sortedServerInterceptors == null) {
            this.sortedServerInterceptors = ImmutableList.copyOf(this.initServerInterceptors());
        }
        return this.sortedServerInterceptors;
    }

    protected List<ServerInterceptor> initServerInterceptors() {
        ArrayList<ServerInterceptor> interceptors = new ArrayList<ServerInterceptor>();
        for (GlobalServerInterceptorConfigurer configurer : this.applicationContext.getBeansOfType(GlobalServerInterceptorConfigurer.class).values()) {
            configurer.configureServerInterceptors(interceptors);
        }
        this.sortInterceptors(interceptors);
        return interceptors;
    }

    public void sortInterceptors(List<? extends ServerInterceptor> interceptors) {
        interceptors.sort(InterceptorOrder.beanFactoryAwareOrderComparator((ApplicationContext)this.applicationContext, ServerInterceptor.class));
    }
}

