/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.server.advice;

import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import net.devh.boot.grpc.server.advice.GrpcAdviceDiscoverer;
import net.devh.boot.grpc.server.advice.GrpcExceptionHandler;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.ExceptionDepthComparator;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class GrpcExceptionHandlerMethodResolver
implements InitializingBean {
    private final Map<Class<? extends Throwable>, Method> mappedMethods = new HashMap<Class<? extends Throwable>, Method>(16);
    private final GrpcAdviceDiscoverer grpcAdviceDiscoverer;
    private Class<? extends Throwable>[] annotatedExceptions;

    public GrpcExceptionHandlerMethodResolver(GrpcAdviceDiscoverer grpcAdviceDiscoverer) {
        this.grpcAdviceDiscoverer = Objects.requireNonNull(grpcAdviceDiscoverer, "grpcAdviceDiscoverer");
    }

    public void afterPropertiesSet() throws Exception {
        this.grpcAdviceDiscoverer.getAnnotatedMethods().forEach(this::extractAndMapExceptionToMethod);
    }

    private void extractAndMapExceptionToMethod(Method method) {
        GrpcExceptionHandler annotation = method.getDeclaredAnnotation(GrpcExceptionHandler.class);
        Assert.notNull((Object)annotation, (String)"@GrpcExceptionHandler annotation not found.");
        this.annotatedExceptions = annotation.value();
        this.checkForPresentExceptionToMap(method);
        Set<Class<? extends Throwable>> exceptionsToMap = this.extractExceptions(method.getParameterTypes());
        exceptionsToMap.forEach(exceptionType -> this.addExceptionMapping((Class<? extends Throwable>)exceptionType, method));
    }

    private void checkForPresentExceptionToMap(Method method) {
        if (method.getParameterTypes().length == 0 && this.annotatedExceptions.length == 0) {
            throw new IllegalStateException(String.format("@GrpcExceptionHandler annotated method [%s] has no mapped exception!", method.getName()));
        }
    }

    private Set<Class<? extends Throwable>> extractExceptions(Class<?>[] methodParamTypes) {
        HashSet<Class<? extends Throwable>> exceptionsToBeMapped = new HashSet<Class<? extends Throwable>>();
        for (Class<? extends Throwable> annoClass : this.annotatedExceptions) {
            if (methodParamTypes.length > 0) {
                this.validateAppropriateParentException(annoClass, methodParamTypes);
            }
            exceptionsToBeMapped.add(annoClass);
        }
        this.addMappingInCaseAnnotationIsEmpty(methodParamTypes, exceptionsToBeMapped);
        return exceptionsToBeMapped;
    }

    private void validateAppropriateParentException(Class<? extends Throwable> annoClass, Class<?>[] methodParamTypes) {
        boolean paramTypeIsNotSuperclass = Arrays.stream(methodParamTypes).noneMatch(param -> param.isAssignableFrom(annoClass));
        if (paramTypeIsNotSuperclass) {
            throw new IllegalStateException(String.format("no listed parameter argument [%s] is equal or superclass of annotated @GrpcExceptionHandler method declared exception [%s].", Arrays.toString(methodParamTypes), annoClass));
        }
    }

    private void addMappingInCaseAnnotationIsEmpty(Class<?>[] methodParamTypes, Set<Class<? extends Throwable>> exceptionsToBeMapped) {
        Function<Class, Class> convertSafely = clazz -> clazz;
        Arrays.stream(methodParamTypes).filter(param -> exceptionsToBeMapped.isEmpty()).filter(Throwable.class::isAssignableFrom).map(convertSafely).forEach(exceptionsToBeMapped::add);
    }

    private void addExceptionMapping(Class<? extends Throwable> exceptionType, Method method) {
        Method oldMethod = this.mappedMethods.put(exceptionType, method);
        if (oldMethod != null && !oldMethod.equals(method)) {
            throw new IllegalStateException("Ambiguous @GrpcExceptionHandler method mapped for [" + exceptionType + "]: {" + oldMethod + ", " + method + "}");
        }
    }

    @NonNull
    public <E extends Throwable> Map.Entry<Object, Method> resolveMethodWithInstance(Class<E> exceptionType) {
        Method value = this.extractExtendedThrowable(exceptionType);
        if (value == null) {
            return new AbstractMap.SimpleImmutableEntry<Object, Object>(null, null);
        }
        Class<?> methodClass = value.getDeclaringClass();
        Object key = this.grpcAdviceDiscoverer.getAnnotatedBeans().values().stream().filter(obj -> methodClass.isAssignableFrom(obj.getClass())).findFirst().orElse(null);
        return new AbstractMap.SimpleImmutableEntry<Object, Method>(key, value);
    }

    public <E extends Throwable> boolean isMethodMappedForException(Class<E> exception) {
        return this.extractExtendedThrowable(exception) != null;
    }

    @Nullable
    private <E extends Throwable> Method extractExtendedThrowable(Class<E> exceptionType) {
        return this.mappedMethods.keySet().stream().filter(ex -> ex.isAssignableFrom(exceptionType)).min((Comparator<Class>)new ExceptionDepthComparator(exceptionType)).map(this.mappedMethods::get).orElse(null);
    }
}

