/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.server.autoconfigure;

import brave.grpc.GrpcTracing;
import net.devh.boot.grpc.common.autoconfigure.GrpcCommonTraceAutoConfiguration;
import net.devh.boot.grpc.server.interceptor.GlobalServerInterceptorConfigurer;
import net.devh.boot.grpc.server.interceptor.OrderedServerInterceptor;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"spring.sleuth.grpc.enabled"}, matchIfMissing=true)
@AutoConfigureAfter(value={GrpcCommonTraceAutoConfiguration.class})
@ConditionalOnBean(value={GrpcTracing.class})
public class GrpcServerTraceAutoConfiguration {
    @Bean
    public GlobalServerInterceptorConfigurer globalTraceServerInterceptorConfigurer(GrpcTracing grpcTracing) {
        return registry -> registry.addServerInterceptors(new OrderedServerInterceptor(grpcTracing.newServerInterceptor(), 2501));
    }
}

