/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.server.autoconfigure;

import com.alibaba.cloud.nacos.NacosDiscoveryProperties;
import com.alibaba.cloud.nacos.registry.NacosRegistration;
import com.alibaba.nacos.client.naming.NacosNamingService;
import javax.annotation.PostConstruct;
import net.devh.boot.grpc.server.config.GrpcServerProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties
@ConditionalOnClass(value={NacosDiscoveryProperties.class, NacosNamingService.class})
public class GrpcMetadataNacosConfiguration {
    @Autowired(required=false)
    private NacosRegistration nacosRegistration;
    @Autowired
    private GrpcServerProperties grpcProperties;

    @PostConstruct
    public void init() {
        if (this.nacosRegistration == null) {
            return;
        }
        int port = this.grpcProperties.getPort();
        if (port != -1) {
            this.nacosRegistration.getMetadata().put("gRPC.port", Integer.toString(port));
        }
    }
}

