/*
 * Decompiled with CFR 0.152.
 */
package net.digger.util.vt;

import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import net.digger.util.fsm.ActionHandler;
import net.digger.util.fsm.EventMapper;
import net.digger.util.vt.Action;
import net.digger.util.vt.State;
import net.digger.util.vt.VTEmulator;
import net.digger.util.vt.VTParserStateMachine;

public class VTParser
implements ActionHandler<Action, State, Character> {
    private static final int MAX_INTERMEDIATE_CHARS = 2;
    private static final int MAX_PARAMS = 16;
    private VTParserStateMachine stateMachine;
    private VTEmulator emulator;
    private int intermediateCharCount;
    private char[] intermediateChars;
    private boolean tooManyIntermediateChars;
    private int paramCount;
    private Integer[] params;
    private boolean tooManyParams;

    public VTParser(VTEmulator emulator) {
        this(emulator, false);
    }

    public VTParser(VTEmulator emulator, boolean use7bits) {
        this.stateMachine = use7bits ? new VTParserStateMachine(this, (EventMapper<Character>)((EventMapper)event -> Character.valueOf((char)Math.min(127, event.charValue())))) : new VTParserStateMachine(this, (EventMapper<Character>)((EventMapper)event -> {
            if ((event = Character.valueOf((char)Math.min(255, event.charValue()))).charValue() > '\u009f') {
                event = Character.valueOf((char)(event.charValue() & 0x7F));
            }
            return event;
        }));
        this.emulator = emulator;
        this.clear();
    }

    public void parse(char ch) {
        this.stateMachine.handleEvent(Character.valueOf(ch));
    }

    public void parse(String str) {
        for (int i = 0; i < str.length(); ++i) {
            this.stateMachine.handleEvent(Character.valueOf(str.charAt(i)));
        }
    }

    public static String stripString(String text, boolean use7bits) {
        final StringBuilder sb = new StringBuilder();
        VTParser vtp = new VTParser(new VTEmulator(){

            @Override
            public void actionExecute(char ch) {
                sb.append(ch);
            }

            @Override
            public void actionPrint(char ch) {
                sb.append(ch);
            }
        }, use7bits);
        vtp.parse(text);
        return sb.toString();
    }

    private void clear() {
        this.intermediateCharCount = 0;
        this.intermediateChars = new char[2];
        this.tooManyIntermediateChars = false;
        this.paramCount = 0;
        this.params = new Integer[16];
        this.tooManyParams = false;
    }

    public void onEntry(State state, Action action) {
        this.doAction(action, '\u0000');
    }

    public void onEvent(State state, Character event, Action action) {
        this.doAction(action, event.charValue());
    }

    public void onExit(State state, Action action) {
        this.doAction(action, '\u0000');
    }

    private void doAction(Action action, char ch) {
        switch (action) {
            case CSI_DISPATCH: {
                if (this.emulator == null || this.tooManyIntermediateChars) break;
                this.emulator.actionCSIDispatch(ch, this.intermediateCharList(), this.paramList());
                break;
            }
            case DCS_HOOK: {
                if (this.emulator == null || this.tooManyIntermediateChars) break;
                this.emulator.actionDCSHook(ch, this.intermediateCharList(), this.paramList());
                break;
            }
            case DCS_PUT: {
                if (this.emulator == null || this.tooManyIntermediateChars) break;
                this.emulator.actionDCSPut(ch);
                break;
            }
            case DCS_UNHOOK: {
                if (this.emulator == null || this.tooManyIntermediateChars) break;
                this.emulator.actionDCSUnhook();
                break;
            }
            case ERROR: {
                if (this.emulator == null) break;
                this.emulator.actionError();
                break;
            }
            case ESC_DISPATCH: {
                if (this.emulator == null || this.tooManyIntermediateChars) break;
                this.emulator.actionEscapeDispatch(ch, this.intermediateCharList());
                break;
            }
            case EXECUTE: {
                if (this.emulator == null) break;
                this.emulator.actionExecute(ch);
                break;
            }
            case OSC_END: {
                if (this.emulator == null) break;
                this.emulator.actionOSCEnd();
                break;
            }
            case OSC_PUT: {
                if (this.emulator == null) break;
                this.emulator.actionOSCPut(ch);
                break;
            }
            case OSC_START: {
                if (this.emulator == null) break;
                this.emulator.actionOSCStart();
                break;
            }
            case PRINT: {
                if (this.emulator == null) break;
                this.emulator.actionPrint(ch);
                break;
            }
            case IGNORE: {
                break;
            }
            case CLEAR: {
                this.clear();
                break;
            }
            case COLLECT: {
                if (this.intermediateCharCount + 1 > 2) {
                    this.tooManyIntermediateChars = true;
                    break;
                }
                this.intermediateChars[this.intermediateCharCount] = ch;
                ++this.intermediateCharCount;
                break;
            }
            case PARAM: {
                if (this.paramCount == 0) {
                    ++this.paramCount;
                }
                if (ch == ';') {
                    if (this.paramCount + 1 > 16) {
                        this.tooManyParams = true;
                        break;
                    }
                    ++this.paramCount;
                    break;
                }
                if (this.tooManyParams) break;
                int current_param = this.paramCount - 1;
                if (this.params[current_param] == null) {
                    this.params[current_param] = 0;
                }
                Integer[] integerArray = this.params;
                int n = current_param;
                Integer.valueOf(integerArray[n] * 10);
                integerArray = this.params;
                n = current_param;
                Integer.valueOf(integerArray[n] + (ch - 48));
            }
        }
    }

    private List<Character> intermediateCharList() {
        ArrayList<Character> charlist = new ArrayList<Character>();
        for (int i = 0; i < this.intermediateCharCount; ++i) {
            charlist.add(Character.valueOf(this.intermediateChars[i]));
        }
        return charlist;
    }

    private List<Integer> paramList() {
        ArrayList<Integer> paramlist = new ArrayList<Integer>();
        for (int i = 0; i < this.paramCount; ++i) {
            paramlist.add(this.params[i]);
        }
        return paramlist;
    }

    public static void main(String[] args) {
        final StringBuilder sb = new StringBuilder();
        VTParser parser = new VTParser(new VTEmulator(){

            @Override
            public void actionCSIDispatch(char ch, List<Character> intermediateChars, List<Integer> params) {
                this.printAction(Action.CSI_DISPATCH, Character.valueOf(ch), intermediateChars, params);
            }

            @Override
            public void actionDCSHook(char ch, List<Character> intermediateChars, List<Integer> params) {
                this.printAction(Action.DCS_HOOK, Character.valueOf(ch), intermediateChars, params);
            }

            @Override
            public void actionDCSPut(char ch) {
                this.printAction(Action.DCS_PUT, Character.valueOf(ch), null, null);
            }

            @Override
            public void actionDCSUnhook() {
                this.printAction(Action.DCS_UNHOOK, null, null, null);
            }

            @Override
            public void actionError() {
                this.printAction(Action.ERROR, null, null, null);
            }

            @Override
            public void actionEscapeDispatch(char ch, List<Character> intermediateChars) {
                this.printAction(Action.ESC_DISPATCH, Character.valueOf(ch), intermediateChars, null);
            }

            @Override
            public void actionExecute(char ch) {
                this.printAction(Action.EXECUTE, Character.valueOf(ch), null, null);
                sb.append(ch);
            }

            @Override
            public void actionOSCEnd() {
                this.printAction(Action.OSC_END, null, null, null);
            }

            @Override
            public void actionOSCPut(char ch) {
                this.printAction(Action.OSC_PUT, Character.valueOf(ch), null, null);
            }

            @Override
            public void actionOSCStart() {
                this.printAction(Action.OSC_START, null, null, null);
            }

            @Override
            public void actionPrint(char ch) {
                this.printAction(Action.PRINT, Character.valueOf(ch), null, null);
                sb.append(ch);
            }

            private void printAction(Action action, Character ch, List<Character> intermediateChars, List<Integer> params) {
                System.out.printf("Received action %s", new Object[]{action});
                if (ch != null && ch.charValue() != '\u0000') {
                    System.out.printf(", Char: 0x%02x ('%c')\n", ch.charValue(), ch);
                }
                if (intermediateChars != null && !intermediateChars.isEmpty()) {
                    System.out.printf("\t%d Intermediate chars: ", intermediateChars.size());
                    for (Character intch : intermediateChars) {
                        System.out.printf("0x%02x ('%c'), ", intch.charValue(), intch);
                    }
                    System.out.println();
                }
                if (params != null && !params.isEmpty()) {
                    System.out.printf("\t%d Parameters: ", params.size());
                    for (Integer param : params) {
                        System.out.printf("%d, ", param);
                    }
                    System.out.println();
                }
                System.out.println();
            }
        });
        Scanner in = new Scanner(System.in);
        while (in.hasNextLine()) {
            String line = in.nextLine();
            sb.setLength(0);
            parser.parse(line);
            System.out.println(sb.toString());
        }
        in.close();
    }
}

