/*
 * Decompiled with CFR 0.152.
 */
package net.distilledcode.maven.baselining;

import aQute.bnd.differ.Baseline;
import aQute.bnd.differ.DiffPluginImpl;
import aQute.bnd.osgi.Jar;
import aQute.bnd.service.diff.Delta;
import aQute.bnd.service.diff.Diff;
import aQute.bnd.service.diff.Differ;
import aQute.bnd.version.Version;
import aQute.libg.reporter.ReporterAdapter;
import aQute.service.reporter.Reporter;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.Stack;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import net.distilledcode.maven.baselining.BaselineVersionSelector;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.OverConstrainedVersionException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;

@Mojo(name="baseline", defaultPhase=LifecyclePhase.PACKAGE, requiresProject=true, threadSafe=true)
public class BaselineMojo
extends AbstractMojo {
    public static final String BUNDLE_SYMBOLIC_NAME = "Bundle-SymbolicName";
    public static final String MSG_NO_BASELINE = "No baseline version found";
    public static final String MSG_BASELINING = "Baselining against version %s";
    public static final String MSG_RAISE_VERSION = "Please raise the version of package %s to %s (old: %s -> new: %s)";
    public static final String MSG_LOWER_VERSION = "Please lower the version of package %s to %s (old: %s -> new: %s)";
    public static final String MSG_RAISE_BUNDLE_VERSION = "Please raise the bundle version to %s (old: %s -> new: %s)";
    @Component
    private MavenSession session;
    @Component
    private MavenProject project;
    @Component
    private ArtifactResolver resolver;
    @Component
    private RepositorySystem repositorySystem;
    @Component
    private ArtifactMetadataSource artifactMetadataSource;
    @Parameter(property="baselining.baseline.explain", defaultValue="false")
    private boolean explain;
    @Deprecated
    @Parameter(defaultValue="true")
    private boolean failOnError;
    @Parameter(property="baselining.baseline.enforcement", defaultValue="lowerAndUpperBound")
    private Enforcement enforcement;
    @Parameter(property="baselining.baseline.enforceBundleVersion", defaultValue="false")
    private boolean enforceBundleVersion;
    @Parameter(property="baselining.baseline.skip", defaultValue="false")
    private boolean skip;
    @Parameter(defaultValue="${localRepository}", readonly=true)
    private ArtifactRepository localRepository;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", readonly=true)
    private List<ArtifactRepository> remoteRepositories;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Artifact artifact = this.project.getArtifact();
        if (this.skip) {
            this.getLog().debug((CharSequence)"Execution skipped via property \"baselining.baseline.skip\"");
            return;
        }
        if (!this.isBundle(artifact.getFile())) {
            this.getLog().debug((CharSequence)"Execution skipped, artifact is not a bundle.");
            return;
        }
        try {
            ArtifactVersion baselineVersion = this.computeBaselineVersion(artifact);
            if (baselineVersion == null) {
                this.getLog().info((CharSequence)MSG_NO_BASELINE);
            } else {
                this.getLog().info((CharSequence)String.format(MSG_BASELINING, baselineVersion));
                Artifact baselineArtifact = this.resolveBaselineArtifact(artifact, baselineVersion);
                Baseline baseline = this.baseline(artifact.getFile(), baselineArtifact.getFile());
                Iterator iterator = baseline.getPackageInfos().iterator();
                while (iterator.hasNext()) {
                    Baseline.Info info = (Baseline.Info)iterator.next();
                    if (info.packageDiff.getDelta() != Delta.UNCHANGED) continue;
                    iterator.remove();
                }
                this.reportFindings(baseline);
            }
        }
        catch (MojoFailureException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unexpected exception during mojo execution", e);
        }
    }

    private void reportFindings(Baseline baseline) throws MojoFailureException {
        String msg;
        int comparison;
        Set baselineInfos = baseline.getPackageInfos();
        if (baselineInfos.size() == 0) {
            this.getLog().info((CharSequence)"No API changes found.");
            return;
        }
        if (this.enforcement == Enforcement.lowerAndUpperBound && !this.failOnError) {
            this.enforcement = Enforcement.none;
        }
        StringBuilder failureReport = new StringBuilder();
        for (Baseline.Info info : baselineInfos) {
            comparison = info.newerVersion.compareTo(info.suggestedVersion);
            if (comparison < 0) {
                msg = String.format(MSG_RAISE_VERSION, info.packageName, info.suggestedVersion, info.olderVersion, info.newerVersion);
                switch (this.enforcement) {
                    case lowerAndUpperBound: 
                    case lowerBound: {
                        failureReport.append(msg).append("\n");
                        this.getLog().error((CharSequence)msg);
                        break;
                    }
                    case none: {
                        this.getLog().warn((CharSequence)msg);
                    }
                }
            } else if (comparison > 0) {
                msg = String.format(MSG_LOWER_VERSION, info.packageName, info.suggestedVersion, info.olderVersion, info.newerVersion);
                switch (this.enforcement) {
                    case lowerAndUpperBound: {
                        failureReport.append(msg).append("\n");
                        this.getLog().error((CharSequence)msg);
                        break;
                    }
                    case lowerBound: 
                    case none: {
                        this.getLog().warn((CharSequence)msg);
                    }
                }
            }
            if (comparison == 0 || !this.explain) continue;
            BaselineMojo.explain(this.getLog(), info.packageDiff, new Stack<Diff>());
        }
        if (this.enforceBundleVersion) {
            Version suggestedBundleVersion = baseline.getSuggestedVersion();
            Version newerBundleVersion = baseline.getNewerVersion();
            comparison = newerBundleVersion.compareTo(suggestedBundleVersion);
            if (comparison < 0) {
                msg = String.format(MSG_RAISE_BUNDLE_VERSION, suggestedBundleVersion, baseline.getOlderVersion(), newerBundleVersion);
                switch (this.enforcement) {
                    case lowerAndUpperBound: 
                    case lowerBound: {
                        failureReport.append(msg).append("\n");
                        this.getLog().error((CharSequence)msg);
                        break;
                    }
                    case none: {
                        this.getLog().warn((CharSequence)msg);
                    }
                }
            }
        }
        if (failureReport.length() > 0) {
            throw new MojoFailureException("There were API changes, please adjust the following exported package versions.\n\n" + failureReport.toString());
        }
    }

    private static void explain(Log log, Diff diff, Stack<Diff> ancestorDiffs) {
        ancestorDiffs.push(diff);
        block0 : switch (diff.getDelta()) {
            case ADDED: 
            case REMOVED: {
                switch (diff.getType()) {
                    case VERSION: {
                        break block0;
                    }
                }
                boolean added = diff.getDelta() == Delta.ADDED;
                Delta severity = added ? diff.getNewer().ifAdded() : diff.getOlder().ifRemoved();
                String prefix = added ? "  added " : "removed ";
                log.info((CharSequence)(severity.toString().toLowerCase(Locale.US) + ": " + prefix + BaselineMojo.ancestorsToString(ancestorDiffs)));
                break;
            }
            case CHANGED: 
            case MAJOR: 
            case MINOR: 
            case MICRO: {
                Collection children = diff.getChildren();
                for (Diff childDiff : children) {
                    BaselineMojo.explain(log, childDiff, ancestorDiffs);
                }
                break;
            }
        }
        ancestorDiffs.pop();
    }

    private static String ancestorsToString(Stack<Diff> ancestorDiffs) {
        StringBuilder sb = new StringBuilder();
        String description = ancestorDiffs.peek().getType().toString().toLowerCase();
        String packageName = ((Diff)ancestorDiffs.get(0)).getName();
        sb.append(description).append(" ");
        block12: for (Diff diff : ancestorDiffs) {
            switch (diff.getType()) {
                case EXTENDS: 
                case IMPLEMENTS: {
                    sb.replace(0, description.length(), "inheritance");
                    sb.append(" ").append(description).append(" ");
                    sb.append(BaselineMojo.fqnToAbbreviatedClassName(diff.getName(), packageName));
                    continue block12;
                }
                case CLASS: 
                case ENUM: 
                case INTERFACE: {
                    sb.append(BaselineMojo.fqnToAbbreviatedClassName(diff.getName(), packageName));
                    continue block12;
                }
                case CONSTANT: 
                case FIELD: {
                    sb.append("#").append(diff.getName());
                    continue block12;
                }
                case METHOD: {
                    sb.append("#").append(BaselineMojo.abbreviateMethodArguments(diff.getName(), packageName));
                    continue block12;
                }
                case ANNOTATED: {
                    sb.append(" with ").append(diff.getName());
                    continue block12;
                }
                case PROPERTY: {
                    sb.insert(0, "annotation-");
                    sb.append("(").append(diff.getName()).append(")");
                    continue block12;
                }
                case VERSION: {
                    continue block12;
                }
                case RETURN: {
                    sb.insert(description.length() + 1, BaselineMojo.fqnToAbbreviatedClassName(diff.getName(), packageName) + " from ");
                    continue block12;
                }
                case ACCESS: {
                    sb.insert(description.length(), diff.getName() + " of");
                    continue block12;
                }
                case PACKAGE: {
                    if (ancestorDiffs.size() != 1) continue block12;
                    sb.append(diff.getName());
                    continue block12;
                }
            }
            sb.append(" *** ");
            sb.append(diff.getName());
        }
        return sb.toString();
    }

    private static String abbreviateMethodArguments(String methodSignature, String packageName) {
        int open = methodSignature.indexOf("(");
        int close = methodSignature.indexOf(")");
        String argumentString = methodSignature.substring(open + 1, close);
        String[] arguments = argumentString.split(",");
        StringBuilder sb = new StringBuilder(methodSignature.substring(0, open + 1));
        for (String arg : arguments) {
            sb.append(BaselineMojo.fqnToAbbreviatedClassName(arg, packageName)).append(",");
        }
        sb.setLength(sb.length() - 1);
        sb.append(methodSignature.substring(close, methodSignature.length()));
        return sb.toString();
    }

    private static String fqnToAbbreviatedClassName(String className, String packageName) {
        if (className.startsWith(packageName)) {
            return className.substring(packageName.length() + 1);
        }
        return className;
    }

    private Artifact resolveBaselineArtifact(Artifact artifact, ArtifactVersion baselineVersion) throws ArtifactNotFoundException, ArtifactResolutionException {
        Artifact baselineArtifact = this.repositorySystem.createArtifact(artifact.getGroupId(), artifact.getArtifactId(), baselineVersion.toString(), "compile", "jar");
        this.resolveArtifact(baselineArtifact);
        return baselineArtifact;
    }

    private void resolveArtifact(Artifact baselineArtifact) {
        ArtifactResolutionRequest request = new ArtifactResolutionRequest();
        request.setArtifact(baselineArtifact);
        request.setLocalRepository(this.localRepository);
        request.setRemoteRepositories(this.remoteRepositories);
        request.setOffline(this.session.isOffline());
        this.repositorySystem.resolve(request);
    }

    private ArtifactVersion computeBaselineVersion(Artifact artifact) throws ArtifactMetadataRetrievalException, OverConstrainedVersionException {
        ArtifactVersion currentVersion = artifact.getSelectedVersion();
        List<ArtifactVersion> availableVersions = this.getAvailableVersions(artifact);
        return BaselineVersionSelector.selectBaselineVersion(currentVersion, availableVersions);
    }

    private Baseline baseline(File newer, File older) throws Exception {
        Baseline baseline = new Baseline((Reporter)new ReporterAdapter(), (Differ)new DiffPluginImpl());
        Jar n = new Jar(newer);
        Jar o = new Jar(older);
        baseline.baseline(n, o, null);
        return baseline;
    }

    private List<ArtifactVersion> getAvailableVersions(Artifact artifact) throws ArtifactMetadataRetrievalException {
        Artifact nonSnapshotArtifact;
        if (artifact.isSnapshot()) {
            String version = this.project.getVersion();
            int snapshotIdx = version.indexOf("-SNAPSHOT");
            String nonSnapshotVersion = version.substring(0, snapshotIdx);
            nonSnapshotArtifact = this.repositorySystem.createArtifact(artifact.getGroupId(), artifact.getArtifactId(), nonSnapshotVersion, "compile", "jar");
        } else {
            nonSnapshotArtifact = artifact;
        }
        List versions = this.artifactMetadataSource.retrieveAvailableVersions(nonSnapshotArtifact, this.localRepository, this.remoteRepositories);
        return versions;
    }

    private boolean isBundle(File artifactFile) {
        if (artifactFile == null || !artifactFile.getName().endsWith(".jar") || !artifactFile.exists()) {
            return false;
        }
        Manifest manifest = this.loadManifest(artifactFile);
        if (manifest == null) {
            return false;
        }
        String symbolicName = manifest.getMainAttributes().getValue(BUNDLE_SYMBOLIC_NAME);
        return symbolicName != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Manifest loadManifest(File artifactFile) {
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(artifactFile, false, 1);
            Manifest manifest = jarFile.getManifest();
            return manifest;
        }
        catch (IOException ioe) {
            this.getLog().error((CharSequence)"Error reading JAR manifest:", (Throwable)ioe);
            Manifest manifest = null;
            return manifest;
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    public static enum Enforcement {
        lowerAndUpperBound,
        lowerBound,
        none;

    }
}

