/*
 * Decompiled with CFR 0.152.
 */
package net.distilledcode.maven.baselining;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.apache.maven.artifact.versioning.ArtifactVersion;

public class BaselineVersionSelector {
    private BaselineVersionSelector() {
    }

    public static ArtifactVersion selectBaselineVersion(ArtifactVersion current, Collection<ArtifactVersion> otherVersions) {
        ArrayList<ArtifactVersion> candidateVersions = new ArrayList<ArtifactVersion>(otherVersions);
        BaselineVersionSelector.removeSnapshotVersions(candidateVersions);
        BaselineVersionSelector.removeVersionsSmallerThanCurrent(current, candidateVersions);
        Collections.sort(candidateVersions, Collections.reverseOrder());
        return candidateVersions.size() > 0 ? (ArtifactVersion)candidateVersions.get(0) : null;
    }

    private static void removeVersionsSmallerThanCurrent(ArtifactVersion current, Iterable<ArtifactVersion> versions) {
        Iterator<ArtifactVersion> versionIterator = versions.iterator();
        while (versionIterator.hasNext()) {
            ArtifactVersion version = versionIterator.next();
            if (version.compareTo((Object)current) < 0) continue;
            versionIterator.remove();
        }
    }

    private static void removeSnapshotVersions(Iterable<ArtifactVersion> versions) {
        Iterator<ArtifactVersion> versionIterator = versions.iterator();
        while (versionIterator.hasNext()) {
            ArtifactVersion version = versionIterator.next();
            if (!"SNAPSHOT".equals(version.getQualifier())) continue;
            versionIterator.remove();
        }
    }
}

