/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.async;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.async.PacketSendingQueue;
import com.comphenix.protocol.concurrency.ConcurrentPlayerMap;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.injector.collection.InboundPacketListenerSet;
import com.comphenix.protocol.injector.collection.OutboundPacketListenerSet;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.bukkit.entity.Player;

class PlayerSendingHandler {
    private final ConcurrentMap<Player, QueueContainer> playerSendingQueues;
    private final OutboundPacketListenerSet outboundTimeoutListeners;
    private final InboundPacketListenerSet inboundTimeoutListeners;
    private Executor asynchronousSender;
    private volatile boolean cleaningUp;

    public PlayerSendingHandler(OutboundPacketListenerSet serverTimeoutListeners, InboundPacketListenerSet clientTimeoutListeners) {
        this.outboundTimeoutListeners = serverTimeoutListeners;
        this.inboundTimeoutListeners = clientTimeoutListeners;
        this.playerSendingQueues = ConcurrentPlayerMap.usingAddress();
    }

    public synchronized void initializeScheduler() {
        if (this.asynchronousSender == null) {
            ThreadFactory factory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("ProtocolLib-AsyncSender %s").build();
            this.asynchronousSender = Executors.newSingleThreadExecutor(factory);
        }
    }

    public PacketSendingQueue getSendingQueue(PacketEvent packet) {
        return this.getSendingQueue(packet, true);
    }

    public PacketSendingQueue getSendingQueue(PacketEvent packet, boolean createNew) {
        QueueContainer queues = (QueueContainer)this.playerSendingQueues.get(packet.getPlayer());
        if (queues == null && createNew) {
            QueueContainer newContainer = new QueueContainer();
            queues = this.playerSendingQueues.putIfAbsent(packet.getPlayer(), newContainer);
            if (queues == null) {
                queues = newContainer;
            }
        }
        if (queues != null) {
            return packet.isServerPacket() ? queues.getOutboundQueue() : queues.getInboundQueue();
        }
        return null;
    }

    public void sendAllPackets() {
        if (!this.cleaningUp) {
            for (QueueContainer queues : this.playerSendingQueues.values()) {
                queues.getInboundQueue().cleanupAll();
                queues.getOutboundQueue().cleanupAll();
            }
        }
    }

    public void sendServerPackets(List<PacketType> types, boolean synchronusOK) {
        if (!this.cleaningUp) {
            for (QueueContainer queue : this.playerSendingQueues.values()) {
                queue.getOutboundQueue().signalPacketUpdate(types, synchronusOK);
            }
        }
    }

    public void sendClientPackets(List<PacketType> types, boolean synchronusOK) {
        if (!this.cleaningUp) {
            for (QueueContainer queue : this.playerSendingQueues.values()) {
                queue.getInboundQueue().signalPacketUpdate(types, synchronusOK);
            }
        }
    }

    public void trySendServerPackets(boolean onMainThread) {
        for (QueueContainer queue : this.playerSendingQueues.values()) {
            queue.getOutboundQueue().trySendPackets(onMainThread);
        }
    }

    public void trySendClientPackets(boolean onMainThread) {
        for (QueueContainer queue : this.playerSendingQueues.values()) {
            queue.getInboundQueue().trySendPackets(onMainThread);
        }
    }

    public List<PacketSendingQueue> getServerQueues() {
        ArrayList<PacketSendingQueue> result = new ArrayList<PacketSendingQueue>();
        for (QueueContainer queue : this.playerSendingQueues.values()) {
            result.add(queue.getOutboundQueue());
        }
        return result;
    }

    public List<PacketSendingQueue> getClientQueues() {
        ArrayList<PacketSendingQueue> result = new ArrayList<PacketSendingQueue>();
        for (QueueContainer queue : this.playerSendingQueues.values()) {
            result.add(queue.getInboundQueue());
        }
        return result;
    }

    public void cleanupAll() {
        if (!this.cleaningUp) {
            this.cleaningUp = true;
            this.sendAllPackets();
            this.playerSendingQueues.clear();
        }
    }

    public void removePlayer(Player player) {
        this.playerSendingQueues.remove(player);
    }

    private class QueueContainer {
        private final PacketSendingQueue outboundQueue;
        private final PacketSendingQueue inboundQueue;

        public QueueContainer() {
            this.outboundQueue = new PacketSendingQueue(false, PlayerSendingHandler.this.asynchronousSender){

                @Override
                protected void onPacketTimeout(PacketEvent event) {
                    if (!PlayerSendingHandler.this.cleaningUp) {
                        PlayerSendingHandler.this.outboundTimeoutListeners.invoke(event);
                    }
                }
            };
            this.inboundQueue = new PacketSendingQueue(true, PlayerSendingHandler.this.asynchronousSender){

                @Override
                protected void onPacketTimeout(PacketEvent event) {
                    if (!PlayerSendingHandler.this.cleaningUp) {
                        PlayerSendingHandler.this.inboundTimeoutListeners.invoke(event);
                    }
                }
            };
        }

        public PacketSendingQueue getOutboundQueue() {
            return this.outboundQueue;
        }

        public PacketSendingQueue getInboundQueue() {
            return this.inboundQueue;
        }
    }
}

