/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.injector.netty;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.reflect.accessors.MethodAccessor;
import com.comphenix.protocol.utility.MinecraftMethods;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.utility.StreamSerializer;
import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.ReferenceCountUtil;
import java.util.Arrays;

public class WirePacket {
    private final int id;
    private final byte[] bytes;

    public WirePacket(PacketType type, byte[] bytes) {
        this.id = ((PacketType)Preconditions.checkNotNull((Object)type, (Object)"type cannot be null")).getCurrentId();
        this.bytes = bytes;
    }

    public WirePacket(int id, byte[] bytes) {
        this.id = id;
        this.bytes = bytes;
    }

    public static WirePacket fromPacket(PacketContainer packet) {
        int id = packet.getType().getCurrentId();
        return new WirePacket(id, WirePacket.bytesFromPacket(packet));
    }

    public static byte[] bytesFromPacket(PacketContainer packet) {
        Preconditions.checkNotNull((Object)packet, (Object)"packet cannot be null!");
        ByteBuf buffer = PacketContainer.createPacketBuffer();
        ByteBuf store = PacketContainer.createPacketBuffer();
        MethodAccessor write = MinecraftMethods.getPacketWriteByteBufMethod();
        write.invoke(packet.getHandle(), buffer);
        byte[] bytes = StreamSerializer.getDefault().getBytesAndRelease(buffer);
        if (packet.getType() == PacketType.Play.Server.CUSTOM_PAYLOAD || packet.getType() == PacketType.Play.Client.CUSTOM_PAYLOAD) {
            byte[] ret = Arrays.copyOf(bytes, bytes.length);
            store.writeBytes(bytes);
            MethodAccessor read = MinecraftMethods.getPacketReadByteBufMethod();
            read.invoke(packet.getHandle(), store);
            bytes = ret;
        }
        ReferenceCountUtil.safeRelease((Object)store);
        return bytes;
    }

    public static WirePacket fromPacket(Object packet) {
        Preconditions.checkNotNull((Object)packet, (Object)"packet cannot be null!");
        Preconditions.checkArgument((boolean)MinecraftReflection.isPacketClass(packet), (Object)"packet must be a Minecraft packet");
        ByteBuf buffer = PacketContainer.createPacketBuffer();
        MethodAccessor write = MinecraftMethods.getPacketWriteByteBufMethod();
        write.invoke(packet, buffer);
        byte[] bytes = StreamSerializer.getDefault().getBytesAndRelease(buffer);
        int id = PacketType.fromClass(packet.getClass()).getCurrentId();
        return new WirePacket(id, bytes);
    }

    public static void writeVarInt(ByteBuf output, int value) {
        while (true) {
            if ((value & 0xFFFFFF80) == 0) break;
            output.writeByte(value & 0x7F | 0x80);
            value >>>= 7;
        }
        output.writeByte(value);
    }

    public static int readVarInt(ByteBuf input) {
        int result = 0;
        for (int j = 0; j < 5; j = (int)((byte)(j + 1))) {
            byte nextByte = input.readByte();
            result |= (nextByte & 0x7F) << j * 7;
            if ((nextByte & 0x80) == 128) continue;
            return result;
        }
        throw new RuntimeException("VarInt is too big");
    }

    public int getId() {
        return this.id;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public void writeId(ByteBuf output) {
        WirePacket.writeVarInt(output, this.id);
    }

    public void writeBytes(ByteBuf output) {
        Preconditions.checkNotNull((Object)output, (Object)"output cannot be null!");
        output.writeBytes(this.bytes);
    }

    public void writeFully(ByteBuf output) {
        this.writeId(output);
        this.writeBytes(output);
    }

    public ByteBuf serialize() {
        ByteBuf buffer = Unpooled.buffer();
        this.writeFully(buffer);
        return buffer;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof WirePacket) {
            WirePacket that = (WirePacket)obj;
            return this.id == that.id && Arrays.equals(this.bytes, that.bytes);
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.bytes);
        result = 31 * result + this.id;
        return result;
    }

    public String toString() {
        return "WirePacket[id=" + this.id + ", bytes=" + Arrays.toString(this.bytes) + "]";
    }
}

