/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.injector.netty.channel;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLogger;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.injector.netty.channel.NettyChannelInjector;
import com.comphenix.protocol.injector.packet.PacketRegistry;
import com.comphenix.protocol.utility.MinecraftReflection;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;

final class InboundPacketInterceptor
extends ChannelInboundHandlerAdapter {
    private final NettyChannelInjector injector;

    public InboundPacketInterceptor(NettyChannelInjector injector) {
        this.injector = injector;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (MinecraftReflection.isPacketClass(msg)) {
            PacketType.Protocol protocol = this.injector.getInboundProtocol();
            if (protocol == PacketType.Protocol.UNKNOWN) {
                ProtocolLogger.debug("skipping unknown inbound protocol for {0}", msg.getClass());
                ctx.fireChannelRead(msg);
                return;
            }
            PacketType packetType = PacketRegistry.getPacketType(protocol, msg.getClass());
            if (packetType == null) {
                ProtocolLogger.debug("skipping unknown inbound packet type for {0}", msg.getClass());
                ctx.fireChannelRead(msg);
                return;
            }
            if (!this.injector.hasInboundListener(packetType)) {
                ctx.fireChannelRead(msg);
                return;
            }
            this.injector.processInbound(ctx, new PacketContainer(packetType, msg));
        } else {
            ctx.fireChannelRead(msg);
        }
    }
}

