/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.reflect;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;

public class ExactReflection {
    private static final Joiner COMMA_SEPERATED_JOINER = Joiner.on((String)", ");
    private final Class<?> source;
    private final boolean forceAccess;

    private ExactReflection(Class<?> source, boolean forceAccess) {
        this.source = (Class)Preconditions.checkNotNull(source, (Object)"source class cannot be NULL");
        this.forceAccess = forceAccess;
    }

    public static ExactReflection fromClass(Class<?> source, boolean forceAccess) {
        return new ExactReflection(source, forceAccess);
    }

    public static ExactReflection fromObject(Object reference, boolean forceAccess) {
        return new ExactReflection(reference.getClass(), forceAccess);
    }

    public Method getMethod(String methodName, Class<?> ... parameters) {
        Method method = this.lookupMethod(this.source, methodName, parameters);
        if (method == null) {
            throw new IllegalArgumentException(String.format("Unable to find method %s(%s) in %s", methodName, COMMA_SEPERATED_JOINER.join((Object[])parameters), this.source.getName()));
        }
        return method;
    }

    public Method findMethod(String methodName, Class<?> ... parameters) {
        return this.lookupMethod(this.source, methodName, parameters);
    }

    private Method lookupMethod(Class<?> instanceClass, String methodName, Class<?> ... parameters) {
        for (Method method : instanceClass.getDeclaredMethods()) {
            if (!this.forceAccess && !Modifier.isPublic(method.getModifiers()) || methodName != null && !method.getName().equals(methodName) || !Arrays.equals(method.getParameterTypes(), parameters)) continue;
            return method;
        }
        if (instanceClass.getSuperclass() != null) {
            return this.lookupMethod(instanceClass.getSuperclass(), methodName, parameters);
        }
        return null;
    }

    public Field getField(String fieldName) {
        Field field = this.lookupField(this.source, fieldName);
        if (field == null) {
            throw new IllegalArgumentException(String.format("Unable to find field with name %s in %s.", fieldName, this.source.getName()));
        }
        return field;
    }

    public Field findField(String fieldName) {
        return this.lookupField(this.source, fieldName);
    }

    private Field lookupField(Class<?> instanceClass, String fieldName) {
        for (Field field : instanceClass.getDeclaredFields()) {
            if (!this.forceAccess && !Modifier.isPublic(field.getModifiers()) || !field.getName().equals(fieldName)) continue;
            return field;
        }
        if (instanceClass.getSuperclass() != null) {
            return this.lookupField(instanceClass.getSuperclass(), fieldName);
        }
        return null;
    }

    public Constructor<?> getConstructor(Class<?> ... parameters) {
        Constructor<?> constructor = this.findConstructor(parameters);
        if (constructor == null) {
            throw new IllegalArgumentException(String.format("Unable to find constructor (%s) in %s", COMMA_SEPERATED_JOINER.join((Object[])parameters), this.source.getName()));
        }
        return constructor;
    }

    public Constructor<?> findConstructor(Class<?> ... parameters) {
        try {
            Constructor<?> constructor = this.source.getDeclaredConstructor(parameters);
            return this.forceAccess || Modifier.isPublic(constructor.getModifiers()) ? constructor : null;
        }
        catch (NoSuchMethodException exception) {
            return null;
        }
    }

    public ExactReflection forceAccess() {
        return new ExactReflection(this.source, true);
    }

    public boolean isForceAccess() {
        return this.forceAccess;
    }

    public Class<?> getSource() {
        return this.source;
    }
}

