/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.reflect.accessors;

import com.comphenix.protocol.reflect.accessors.FieldAccessor;
import com.google.common.base.Preconditions;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;

final class DefaultFieldAccessor
implements FieldAccessor {
    private final Field field;
    private final boolean staticField;
    private final MethodHandle setter;
    private final MethodHandle getter;

    public DefaultFieldAccessor(Field field, MethodHandle setter, MethodHandle getter, boolean staticField) {
        this.field = (Field)Preconditions.checkNotNull((Object)field, (Object)"field");
        this.setter = (MethodHandle)Preconditions.checkNotNull((Object)setter, (Object)"setter");
        this.getter = (MethodHandle)Preconditions.checkNotNull((Object)getter, (Object)"getter");
        this.staticField = staticField;
    }

    @Override
    public Object get(Object instance) {
        try {
            return this.staticField ? this.getter.invokeExact() : this.getter.invokeExact(instance);
        }
        catch (Throwable throwable) {
            throw new IllegalStateException("Unable to read field value of " + String.valueOf(this.field), throwable);
        }
    }

    @Override
    public void set(Object instance, Object value) {
        try {
            if (this.staticField) {
                this.setter.invokeExact(value);
            } else {
                this.setter.invokeExact(instance, value);
            }
        }
        catch (Throwable throwable) {
            throw new IllegalStateException("Unable to set value of field " + String.valueOf(this.field), throwable);
        }
    }

    @Override
    public Field getField() {
        return this.field;
    }
}

