/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.reflect.cloning;

import com.comphenix.protocol.reflect.ObjectWriter;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.reflect.cloning.Cloner;
import com.comphenix.protocol.reflect.instances.InstanceProvider;
import com.comphenix.protocol.reflect.instances.NotConstructableException;

public class FieldCloner
implements Cloner {
    protected Cloner defaultCloner;
    protected InstanceProvider instanceProvider;
    protected ObjectWriter writer;

    public FieldCloner(Cloner defaultCloner, InstanceProvider instanceProvider) {
        this.defaultCloner = defaultCloner;
        this.instanceProvider = instanceProvider;
        this.writer = new ObjectWriter(){

            @Override
            protected void transformField(StructureModifier<Object> modifierSource, StructureModifier<Object> modifierDest, int fieldIndex) {
                FieldCloner.this.defaultTransform(modifierDest, modifierDest, FieldCloner.this.getDefaultCloner(), fieldIndex);
            }
        };
    }

    protected void defaultTransform(StructureModifier<Object> modifierSource, StructureModifier<Object> modifierDest, Cloner defaultCloner, int fieldIndex) {
        Object value = modifierSource.read(fieldIndex);
        modifierDest.write(fieldIndex, defaultCloner.clone(value));
    }

    @Override
    public boolean canClone(Object source) {
        if (source == null) {
            return false;
        }
        try {
            return this.instanceProvider.create(source.getClass()) != null;
        }
        catch (NotConstructableException e) {
            return false;
        }
    }

    @Override
    public Object clone(Object source) {
        if (source == null) {
            throw new IllegalArgumentException("source cannot be NULL.");
        }
        Object copy = this.instanceProvider.create(source.getClass());
        this.writer.copyTo(source, copy, source.getClass());
        return copy;
    }

    public Cloner getDefaultCloner() {
        return this.defaultCloner;
    }

    public InstanceProvider getInstanceProvider() {
        return this.instanceProvider;
    }
}

