/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.wrappers;

import com.comphenix.protocol.reflect.EquivalentConverter;
import com.comphenix.protocol.reflect.FieldAccessException;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.google.common.base.Objects;
import java.lang.reflect.Constructor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.util.Vector;

public class BlockPosition {
    public static BlockPosition ORIGIN = new BlockPosition(0, 0, 0);
    private static Constructor<?> blockPositionConstructor;
    protected final int x;
    protected final int y;
    protected final int z;
    private static StructureModifier<Integer> intModifier;

    public BlockPosition(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public BlockPosition(Vector vector) {
        if (vector == null) {
            throw new IllegalArgumentException("Vector cannot be NULL.");
        }
        this.x = vector.getBlockX();
        this.y = vector.getBlockY();
        this.z = vector.getBlockZ();
    }

    public Vector toVector() {
        return new Vector(this.x, this.y, this.z);
    }

    public Location toLocation(World world) {
        return new Location(world, (double)this.x, (double)this.y, (double)this.z);
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public BlockPosition add(BlockPosition other) {
        if (other == null) {
            throw new IllegalArgumentException("other cannot be NULL");
        }
        return new BlockPosition(this.x + other.x, this.y + other.y, this.z + other.z);
    }

    public BlockPosition subtract(BlockPosition other) {
        if (other == null) {
            throw new IllegalArgumentException("other cannot be NULL");
        }
        return new BlockPosition(this.x - other.x, this.y - other.y, this.z - other.z);
    }

    public BlockPosition multiply(int factor) {
        return new BlockPosition(this.x * factor, this.y * factor, this.z * factor);
    }

    public BlockPosition divide(int divisor) {
        if (divisor == 0) {
            throw new IllegalArgumentException("Cannot divide by null.");
        }
        return new BlockPosition(this.x / divisor, this.y / divisor, this.z / divisor);
    }

    public static EquivalentConverter<BlockPosition> getConverter() {
        return new EquivalentConverter<BlockPosition>(){

            @Override
            public Object getGeneric(BlockPosition specific) {
                if (blockPositionConstructor == null) {
                    try {
                        blockPositionConstructor = MinecraftReflection.getBlockPositionClass().getConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Cannot find block position constructor.", e);
                    }
                }
                try {
                    Object result = blockPositionConstructor.newInstance(specific.x, specific.y, specific.z);
                    return result;
                }
                catch (Exception e) {
                    throw new RuntimeException("Cannot construct BlockPosition.", e);
                }
            }

            @Override
            public BlockPosition getSpecific(Object generic) {
                if (MinecraftReflection.isBlockPosition(generic)) {
                    intModifier = new StructureModifier(generic.getClass(), null, false).withType(Integer.TYPE);
                    if (intModifier.size() < 3) {
                        throw new IllegalStateException("Cannot read class " + String.valueOf(generic.getClass()) + " for its integer fields.");
                    }
                    if (intModifier.size() >= 3) {
                        try {
                            StructureModifier<Integer> instance = intModifier.withTarget(generic);
                            BlockPosition result = new BlockPosition(instance.read(0), instance.read(1), instance.read(2));
                            return result;
                        }
                        catch (FieldAccessException e) {
                            throw new RuntimeException("Field access error.", e);
                        }
                    }
                }
                return null;
            }

            @Override
            public Class<BlockPosition> getSpecificType() {
                return BlockPosition.class;
            }
        };
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof BlockPosition) {
            BlockPosition other = (BlockPosition)obj;
            return this.x == other.x && this.y == other.y && this.z == other.z;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.x, this.y, this.z});
    }

    public String toString() {
        return "BlockPosition [x=" + this.x + ", y=" + this.y + ", z=" + this.z + "]";
    }
}

