/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.wrappers;

import com.comphenix.protocol.reflect.EquivalentConverter;
import com.comphenix.protocol.reflect.FuzzyReflection;
import com.comphenix.protocol.reflect.accessors.Accessors;
import com.comphenix.protocol.reflect.accessors.MethodAccessor;
import com.comphenix.protocol.reflect.fuzzy.FuzzyMethodContract;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.wrappers.WrappedRegistry;
import com.google.common.base.Preconditions;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;

public class Converters {
    private static MethodAccessor holderGetValue;

    public static <T> EquivalentConverter<T> ignoreNull(final EquivalentConverter<T> converter) {
        return new EquivalentConverter<T>(){

            @Override
            public T getSpecific(Object generic) {
                return generic != null ? (Object)converter.getSpecific(generic) : null;
            }

            @Override
            public Object getGeneric(T specific) {
                return specific != null ? converter.getGeneric(specific) : null;
            }

            @Override
            public Class<T> getSpecificType() {
                return converter.getSpecificType();
            }
        };
    }

    public static <T> EquivalentConverter<T> passthrough(final Class<T> clazz) {
        return Converters.ignoreNull(new EquivalentConverter<T>(){

            @Override
            public T getSpecific(Object generic) {
                return generic;
            }

            @Override
            public Object getGeneric(T specific) {
                return specific;
            }

            @Override
            public Class<T> getSpecificType() {
                return clazz;
            }
        });
    }

    public static <T> EquivalentConverter<T> handle(final Function<T, Object> toHandle, final Function<Object, T> fromHandle, final Class<T> specificType) {
        return new EquivalentConverter<T>(){

            @Override
            public T getSpecific(Object generic) {
                return fromHandle.apply(generic);
            }

            @Override
            public Object getGeneric(T specific) {
                return toHandle.apply(specific);
            }

            @Override
            public Class<T> getSpecificType() {
                return specificType;
            }
        };
    }

    public static <T> EquivalentConverter<T[]> array(final Class<?> nmsClass, final EquivalentConverter<T> converter) {
        return new EquivalentConverter<T[]>(){

            @Override
            public T[] getSpecific(Object generic) {
                Object[] array = (Object[])generic;
                Class<T[]> clazz = this.getSpecificType();
                T[] result = clazz.cast(Array.newInstance(clazz.getComponentType(), array.length));
                for (int i = 0; i < result.length; ++i) {
                    result[i] = converter.getSpecific(array[i]);
                }
                return result;
            }

            @Override
            public Object getGeneric(T[] specific) {
                Object[] result = (Object[])Array.newInstance(nmsClass, specific.length);
                for (int i = 0; i < result.length; ++i) {
                    result[i] = converter.getGeneric(specific[i]);
                }
                return result;
            }

            @Override
            public Class<T[]> getSpecificType() {
                return MinecraftReflection.getArrayClass(converter.getSpecificType());
            }
        };
    }

    public static <T> EquivalentConverter<Optional<T>> optional(final EquivalentConverter<T> converter) {
        return new EquivalentConverter<Optional<T>>(){

            @Override
            public Object getGeneric(Optional<T> specific) {
                return specific.map(converter::getGeneric);
            }

            @Override
            public Optional<T> getSpecific(Object generic) {
                if (generic == null) {
                    return Optional.empty();
                }
                Optional optional = (Optional)generic;
                return optional.map(converter::getSpecific);
            }

            @Override
            public Class<Optional<T>> getSpecificType() {
                return Optional.empty().getClass();
            }
        };
    }

    public static <T, C extends Collection<T>> EquivalentConverter<C> collection(final EquivalentConverter<T> elementConverter, final Function<Collection<Object>, C> genericToSpecificCollectionFactory, final Function<C, Collection<?>> specificToGenericCollectionFactory) {
        return Converters.ignoreNull(new EquivalentConverter<C>(){

            @Override
            public Object getGeneric(C specific) {
                Collection targetCollection = (Collection)specificToGenericCollectionFactory.apply(specific);
                for (Object element : specific) {
                    Object generic = elementConverter.getGeneric(element);
                    if (generic == null) continue;
                    targetCollection.add(generic);
                }
                return targetCollection;
            }

            @Override
            public C getSpecific(Object generic) {
                if (generic instanceof Collection) {
                    Collection sourceCollection = (Collection)generic;
                    Collection targetCollection = (Collection)genericToSpecificCollectionFactory.apply(sourceCollection);
                    for (Object element : sourceCollection) {
                        Object specific = elementConverter.getSpecific(element);
                        if (specific == null) continue;
                        targetCollection.add(specific);
                    }
                    return targetCollection;
                }
                return null;
            }

            @Override
            public Class<C> getSpecificType() {
                return Collection.class;
            }
        });
    }

    public static <T> EquivalentConverter<Iterable<T>> iterable(final EquivalentConverter<T> elementConverter, final Supplier<List<T>> specificCollectionFactory, final Supplier<List<?>> genericCollectionFactory) {
        return Converters.ignoreNull(new EquivalentConverter<Iterable<T>>(){

            @Override
            public Object getGeneric(Iterable<T> specific) {
                List targetCollection = (List)genericCollectionFactory.get();
                for (Object element : specific) {
                    Object generic = elementConverter.getGeneric(element);
                    if (generic == null) continue;
                    targetCollection.add(generic);
                }
                return targetCollection;
            }

            @Override
            public Iterable<T> getSpecific(Object generic) {
                if (generic instanceof Iterable) {
                    Iterable sourceCollection = (Iterable)generic;
                    List targetCollection = (List)specificCollectionFactory.get();
                    for (Object element : sourceCollection) {
                        Object specific = elementConverter.getSpecific(element);
                        if (specific == null) continue;
                        targetCollection.add(specific);
                    }
                    return targetCollection;
                }
                return null;
            }

            @Override
            public Class<Iterable<T>> getSpecificType() {
                return Iterable.class;
            }
        });
    }

    public static <T> EquivalentConverter<T> holder(final EquivalentConverter<T> converter, final WrappedRegistry registry) {
        return new EquivalentConverter<T>(){

            @Override
            public Object getGeneric(T specific) {
                Object generic = converter.getGeneric(specific);
                return registry.getHolder(generic);
            }

            @Override
            public T getSpecific(Object generic) {
                Preconditions.checkNotNull((Object)generic, (Object)"generic cannot be null");
                if (holderGetValue == null) {
                    Class<?> holderClass = MinecraftReflection.getHolderClass();
                    FuzzyReflection fuzzy = FuzzyReflection.fromClass(holderClass, false);
                    holderGetValue = Accessors.getMethodAccessor(fuzzy.getMethod(FuzzyMethodContract.newBuilder().parameterCount(0).banModifier(8).returnTypeExact(Object.class).build()));
                }
                if (holderGetValue == null) {
                    throw new IllegalStateException("Unable to find Holder#value method.");
                }
                Object value = holderGetValue.invoke(generic, new Object[0]);
                return converter.getSpecific(value);
            }

            @Override
            public Class<T> getSpecificType() {
                return converter.getSpecificType();
            }
        };
    }

    public static <T> List<T> toList(Iterable<? extends T> iterable) {
        if (iterable instanceof List) {
            return (List)iterable;
        }
        ArrayList<T> result = new ArrayList<T>();
        if (iterable instanceof Collection) {
            Collection coll = (Collection)iterable;
            result.addAll(coll);
        } else {
            for (T elem : iterable) {
                result.add(elem);
            }
        }
        return result;
    }
}

