/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.wrappers;

import com.comphenix.protocol.events.InternalStructure;
import com.comphenix.protocol.reflect.EquivalentConverter;
import com.comphenix.protocol.reflect.FuzzyReflection;
import com.comphenix.protocol.reflect.accessors.Accessors;
import com.comphenix.protocol.reflect.accessors.ConstructorAccessor;
import com.comphenix.protocol.reflect.fuzzy.FuzzyMethodContract;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.utility.MinecraftVersion;
import com.comphenix.protocol.wrappers.AbstractWrapper;
import com.comphenix.protocol.wrappers.MinecraftKey;
import com.comphenix.protocol.wrappers.WrappedAttribute;
import com.google.common.base.Preconditions;
import java.lang.reflect.Constructor;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class WrappedAttributeModifier
extends AbstractWrapper {
    private static final boolean OPERATION_ENUM = MinecraftVersion.VILLAGE_UPDATE.atOrAbove();
    static final boolean USES_RESOURCE_LOCATION = MinecraftVersion.v1_21_0.atOrAbove();
    private static final Class<?> OPERATION_CLASS = OPERATION_ENUM ? MinecraftReflection.getMinecraftClass("world.entity.ai.attributes.AttributeModifier$Operation", "AttributeModifier$Operation") : null;
    private static final EquivalentConverter<Operation> OPERATION_CONVERTER = OPERATION_ENUM ? new IndexedEnumConverter<Operation>(Operation.class, OPERATION_CLASS) : null;
    private static ConstructorAccessor ATTRIBUTE_MODIFIER_CONSTRUCTOR;
    protected InternalStructure modifier;
    @Nullable
    private final MinecraftKey key;
    @Nullable
    private final UUID uuid;
    private final Supplier<String> name;
    private final Operation operation;
    private final double amount;

    protected WrappedAttributeModifier(@Nonnull Object handle) {
        super(MinecraftReflection.getAttributeModifierClass());
        this.setHandle(handle);
        this.initializeModifier(handle);
        if (USES_RESOURCE_LOCATION) {
            this.key = this.modifier.getMinecraftKeys().read(0);
            this.uuid = null;
            this.name = () -> null;
        } else {
            this.key = null;
            this.uuid = this.modifier.getUUIDs().read(0);
            Optional<String> name = this.modifier.getStrings().optionRead(0);
            this.name = name.isPresent() ? name::get : (Supplier)this.modifier.getModifier().withType(Supplier.class).read(0);
        }
        this.amount = this.modifier.getDoubles().read(0);
        this.operation = OPERATION_ENUM ? this.modifier.getModifier().withType(OPERATION_CLASS, OPERATION_CONVERTER).readSafely(0) : Operation.fromId(this.modifier.getIntegers().readSafely(0));
    }

    protected WrappedAttributeModifier(@Nonnull Object handle, UUID uuid, String name, double amount, Operation operation) {
        super(MinecraftReflection.getAttributeModifierClass());
        this.uuid = uuid;
        this.name = () -> name;
        this.amount = amount;
        this.operation = operation;
        this.key = null;
        this.setHandle(handle);
        this.initializeModifier(handle);
    }

    protected WrappedAttributeModifier(Object handle, MinecraftKey key, double amount, Operation operation) {
        super(MinecraftReflection.getAttributeModifierClass());
        this.uuid = null;
        this.key = key;
        this.amount = amount;
        this.name = key::toString;
        this.operation = operation;
        this.setHandle(handle);
        this.initializeModifier(handle);
    }

    public static Builder newBuilder() {
        return new Builder(null).uuid(UUID.randomUUID());
    }

    public static Builder newBuilder(UUID id) {
        return new Builder(null).uuid(id);
    }

    public static Builder newBuilder(@Nonnull WrappedAttributeModifier template) {
        return new Builder((WrappedAttributeModifier)Preconditions.checkNotNull((Object)template, (Object)"template cannot be NULL."));
    }

    public static WrappedAttributeModifier fromHandle(@Nonnull Object handle) {
        return new WrappedAttributeModifier(handle);
    }

    private void initializeModifier(@Nonnull Object handle) {
        this.modifier = InternalStructure.getConverter().getSpecific(handle);
    }

    public MinecraftKey getKey() {
        return this.key;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public String getName() {
        return this.name.get();
    }

    public Operation getOperation() {
        return this.operation;
    }

    public double getAmount() {
        return this.amount;
    }

    @Override
    public Object getHandle() {
        return this.handle;
    }

    public void setPendingSynchronization(boolean pending) {
        this.modifier.getBooleans().write(0, pending);
    }

    public boolean isPendingSynchronization() {
        return this.modifier.getBooleans().optionRead(0).orElse(false);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof WrappedAttributeModifier) {
            WrappedAttributeModifier other = (WrappedAttributeModifier)obj;
            if (USES_RESOURCE_LOCATION) {
                return this.key.equals(other.key);
            }
            return this.uuid.equals(other.uuid);
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (USES_RESOURCE_LOCATION) {
            return this.key != null ? this.key.hashCode() : 0;
        }
        return this.uuid != null ? this.uuid.hashCode() : 0;
    }

    @Override
    public String toString() {
        return "[key=" + String.valueOf(this.key) + ", amount=" + this.amount + ", operation=" + String.valueOf((Object)this.operation) + "]";
    }

    private static Object getOperationParam(Operation operation) {
        return OPERATION_ENUM ? OPERATION_CONVERTER.getGeneric(operation) : Integer.valueOf(operation.getId());
    }

    private static ConstructorAccessor getConstructor() {
        FuzzyMethodContract.Builder builder = FuzzyMethodContract.newBuilder();
        if (USES_RESOURCE_LOCATION) {
            builder.parameterCount(3).parameterDerivedOf(MinecraftReflection.getMinecraftKeyClass()).parameterExactType(Double.TYPE).parameterExactType(OPERATION_CLASS);
        } else {
            builder.parameterCount(4).parameterDerivedOf(UUID.class, 0).parameterExactType(String.class, 1).parameterExactType(Double.TYPE, 2);
            if (OPERATION_ENUM) {
                builder.parameterExactType(OPERATION_CLASS, 3);
            } else {
                builder.parameterExactType(Integer.TYPE, 3);
            }
        }
        Constructor<?> ret = FuzzyReflection.fromClass(MinecraftReflection.getAttributeModifierClass(), true).getConstructor(builder.build());
        return Accessors.getConstructorAccessor(ret);
    }

    public static enum Operation {
        ADD_NUMBER(0),
        MULTIPLY_PERCENTAGE(1),
        ADD_PERCENTAGE(2);

        private final int id;

        private Operation(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public static Operation fromId(int id) {
            for (Operation op : Operation.values()) {
                if (op.getId() != id) continue;
                return op;
            }
            throw new IllegalArgumentException("Corrupt operation ID " + id + " detected.");
        }
    }

    public static class Builder {
        private Operation operation = Operation.ADD_NUMBER;
        private String name = "Unknown";
        private double amount;
        private UUID uuid;
        private MinecraftKey key;

        private Builder(WrappedAttributeModifier template) {
            if (template != null) {
                this.operation = template.getOperation();
                this.name = template.getName();
                this.amount = template.getAmount();
                this.uuid = template.getUUID();
                this.key = template.getKey();
            }
        }

        @Deprecated
        public Builder uuid(@Nonnull UUID uuid) {
            this.uuid = (UUID)Preconditions.checkNotNull((Object)uuid, (Object)"uuid cannot be NULL.");
            return this;
        }

        public Builder operation(@Nonnull Operation operation) {
            this.operation = (Operation)((Object)Preconditions.checkNotNull((Object)((Object)operation), (Object)"operation cannot be NULL."));
            return this;
        }

        @Deprecated
        public Builder name(@Nonnull String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name cannot be NULL.");
            return this;
        }

        public Builder key(@Nonnull MinecraftKey key) {
            this.key = (MinecraftKey)Preconditions.checkNotNull((Object)key, (Object)"key cannot be NULL.");
            return this;
        }

        public Builder key(String prefix, String value) {
            return this.key(new MinecraftKey(prefix, value));
        }

        public Builder amount(double amount) {
            this.amount = WrappedAttribute.checkDouble(amount);
            return this;
        }

        public WrappedAttributeModifier build() {
            Preconditions.checkNotNull((Object)this.uuid, (Object)"uuid cannot be NULL.");
            if (ATTRIBUTE_MODIFIER_CONSTRUCTOR == null) {
                ATTRIBUTE_MODIFIER_CONSTRUCTOR = WrappedAttributeModifier.getConstructor();
            }
            try {
                if (USES_RESOURCE_LOCATION) {
                    if (this.key == null) {
                        UUID uuid = this.uuid != null ? this.uuid : UUID.randomUUID();
                        this.key = new MinecraftKey("protocollib", uuid.toString());
                    }
                    Object handle = ATTRIBUTE_MODIFIER_CONSTRUCTOR.invoke(MinecraftKey.getConverter().getGeneric(this.key), this.amount, OPERATION_CONVERTER.getGeneric(this.operation));
                    return new WrappedAttributeModifier(handle, this.key, this.amount, this.operation);
                }
                Object handle = ATTRIBUTE_MODIFIER_CONSTRUCTOR.invoke(this.uuid, this.name, this.amount, WrappedAttributeModifier.getOperationParam(this.operation));
                return new WrappedAttributeModifier(handle, this.uuid, this.name, this.amount, this.operation);
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot construct AttributeModifier.", e);
            }
        }
    }

    private static class IndexedEnumConverter<T extends Enum<T>>
    implements EquivalentConverter<T> {
        private final Class<T> specificClass;
        private final Class<?> genericClass;

        private IndexedEnumConverter(Class<T> specificClass, Class<?> genericClass) {
            this.specificClass = specificClass;
            this.genericClass = genericClass;
        }

        @Override
        public Object getGeneric(T specific) {
            int ordinal = ((Enum)specific).ordinal();
            for (Object elem : this.genericClass.getEnumConstants()) {
                if (((Enum)elem).ordinal() != ordinal) continue;
                return elem;
            }
            return null;
        }

        @Override
        public T getSpecific(Object generic) {
            int ordinal = ((Enum)generic).ordinal();
            for (Enum elem : (Enum[])this.specificClass.getEnumConstants()) {
                if (elem.ordinal() != ordinal) continue;
                return (T)elem;
            }
            return null;
        }

        @Override
        public Class<T> getSpecificType() {
            return this.specificClass;
        }
    }
}

