/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.wrappers;

import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.error.PluginContext;
import com.comphenix.protocol.error.Report;
import com.comphenix.protocol.error.ReportType;
import com.comphenix.protocol.injector.BukkitUnwrapper;
import com.comphenix.protocol.reflect.accessors.Accessors;
import com.comphenix.protocol.reflect.accessors.ConstructorAccessor;
import com.comphenix.protocol.reflect.accessors.FieldAccessor;
import com.comphenix.protocol.reflect.accessors.MethodAccessor;
import com.comphenix.protocol.reflect.instances.MinecraftGenerator;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.utility.MinecraftVersion;
import com.comphenix.protocol.wrappers.AbstractWrapper;
import com.comphenix.protocol.wrappers.GuavaWrappers;
import com.comphenix.protocol.wrappers.WrappedSignedProperty;
import com.comphenix.protocol.wrappers.collection.ConvertedMultimap;
import com.google.common.base.Objects;
import com.google.common.collect.Multimap;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class WrappedGameProfile
extends AbstractWrapper {
    public static final ReportType REPORT_INVALID_UUID = new ReportType("Plugin %s created a profile with '%s' as an UUID.");
    private static final Class<?> GAME_PROFILE = MinecraftReflection.getGameProfileClass();
    private static final ConstructorAccessor CREATE_STRING_STRING = Accessors.getConstructorAccessorOrNull(GAME_PROFILE, String.class, String.class);
    private static final ConstructorAccessor CREATE_UUID_STRING = Accessors.getConstructorAccessorOrNull(GAME_PROFILE, UUID.class, String.class);
    private static final FieldAccessor GET_UUID_STRING = Accessors.getFieldAccessorOrNull(GAME_PROFILE, "id", String.class);
    private static final MethodAccessor GET_ID = Accessors.getMethodAccessorOrNull(GAME_PROFILE, "getId", new Class[0]);
    private static final MethodAccessor GET_NAME = Accessors.getMethodAccessorOrNull(GAME_PROFILE, "getName", new Class[0]);
    private static final MethodAccessor GET_PROPERTIES = Accessors.getMethodAccessorOrNull(GAME_PROFILE, "getProperties", new Class[0]);
    private static final MethodAccessor IS_COMPLETE = Accessors.getMethodAccessorOrNull(GAME_PROFILE, "isComplete", new Class[0]);
    private static FieldAccessor PLAYER_PROFILE;
    private static FieldAccessor OFFLINE_PROFILE;
    private Multimap<String, WrappedSignedProperty> propertyMap;
    private volatile UUID parsedUUID;

    private WrappedGameProfile(Object profile) {
        super(GAME_PROFILE);
        this.setHandle(profile);
    }

    public static WrappedGameProfile fromPlayer(Player player) {
        FieldAccessor accessor = PLAYER_PROFILE;
        if (accessor == null) {
            PLAYER_PROFILE = accessor = Accessors.getFieldAccessor(MinecraftReflection.getEntityHumanClass(), GAME_PROFILE, true);
        }
        Object nmsPlayer = BukkitUnwrapper.getInstance().unwrapItem(player);
        return WrappedGameProfile.fromHandle(PLAYER_PROFILE.get(nmsPlayer));
    }

    public static WrappedGameProfile fromOfflinePlayer(OfflinePlayer player) {
        FieldAccessor accessor = OFFLINE_PROFILE;
        if (accessor == null) {
            OFFLINE_PROFILE = accessor = Accessors.getFieldAccessor(player.getClass(), GAME_PROFILE, true);
        }
        return WrappedGameProfile.fromHandle(OFFLINE_PROFILE.get(player));
    }

    @Deprecated
    public WrappedGameProfile(String id, String name) {
        this(WrappedGameProfile.parseUUID(id), name);
    }

    public WrappedGameProfile(UUID uuid, String name) {
        super(GAME_PROFILE);
        if (CREATE_STRING_STRING != null) {
            this.setHandle(CREATE_STRING_STRING.invoke(uuid != null ? uuid.toString() : null, name));
        } else if (CREATE_UUID_STRING != null) {
            if (MinecraftVersion.CONFIG_PHASE_PROTOCOL_UPDATE.atOrAbove()) {
                if (uuid == null && (name == null || name.isEmpty())) {
                    throw new IllegalArgumentException("Name and ID cannot both be blank");
                }
                this.setHandle(CREATE_UUID_STRING.invoke(uuid == null ? MinecraftGenerator.SYS_UUID : uuid, name == null ? "" : name));
            } else {
                this.setHandle(CREATE_UUID_STRING.invoke(uuid, name));
            }
        } else {
            throw new IllegalArgumentException("Unsupported GameProfile constructor.");
        }
    }

    public static WrappedGameProfile fromHandle(Object handle) {
        if (handle == null) {
            return null;
        }
        return new WrappedGameProfile(handle);
    }

    private static UUID parseUUID(String id) {
        if (id == null) {
            return null;
        }
        try {
            return UUID.fromString(id);
        }
        catch (IllegalArgumentException e) {
            ProtocolLibrary.getErrorReporter().reportWarning(WrappedGameProfile.class, Report.newBuilder(REPORT_INVALID_UUID).rateLimit(1L, TimeUnit.HOURS).messageParam(PluginContext.getPluginCaller(new Exception()), id));
            return UUID.nameUUIDFromBytes(id.getBytes(StandardCharsets.UTF_8));
        }
    }

    public UUID getUUID() {
        UUID uuid = this.parsedUUID;
        if (uuid == null) {
            try {
                if (GET_UUID_STRING != null) {
                    uuid = WrappedGameProfile.parseUUID(this.getId());
                } else if (GET_ID != null) {
                    uuid = (UUID)GET_ID.invoke(this.handle, new Object[0]);
                    if (MinecraftVersion.CONFIG_PHASE_PROTOCOL_UPDATE.atOrAbove() && MinecraftGenerator.SYS_UUID.equals(uuid)) {
                        uuid = null;
                    }
                } else {
                    throw new IllegalStateException("Unsupported getId() method");
                }
                this.parsedUUID = uuid;
            }
            catch (IllegalArgumentException e) {
                throw new IllegalStateException("Cannot parse ID " + this.getId() + " as an UUID in player profile " + this.getName(), e);
            }
        }
        return uuid;
    }

    public String getId() {
        if (GET_UUID_STRING != null) {
            return (String)GET_UUID_STRING.get(this.handle);
        }
        if (GET_ID != null) {
            UUID uuid = this.getUUID();
            return uuid != null ? uuid.toString() : null;
        }
        throw new IllegalStateException("Unsupported getId() method");
    }

    public String getName() {
        if (GET_NAME != null) {
            String name = (String)GET_NAME.invoke(this.handle, new Object[0]);
            if (MinecraftVersion.CONFIG_PHASE_PROTOCOL_UPDATE.atOrAbove() && name != null && name.isEmpty()) {
                name = null;
            }
            return name;
        }
        throw new IllegalStateException("Unsupported getName() method");
    }

    public Multimap<String, WrappedSignedProperty> getProperties() {
        ConvertedMultimap<String, Object, WrappedSignedProperty> result = this.propertyMap;
        if (result == null) {
            Multimap properties = (Multimap)GET_PROPERTIES.invoke(this.handle, new Object[0]);
            this.propertyMap = result = new ConvertedMultimap<String, Object, WrappedSignedProperty>(GuavaWrappers.getBukkitMultimap(properties)){

                @Override
                protected Object toInner(WrappedSignedProperty outer) {
                    return outer.handle;
                }

                @Override
                protected Object toInnerObject(Object outer) {
                    if (outer instanceof WrappedSignedProperty) {
                        return this.toInner((WrappedSignedProperty)outer);
                    }
                    return outer;
                }

                @Override
                protected WrappedSignedProperty toOuter(Object inner) {
                    return WrappedSignedProperty.fromHandle(inner);
                }
            };
        }
        return result;
    }

    public WrappedGameProfile withName(String name) {
        return new WrappedGameProfile(this.getId(), name);
    }

    public WrappedGameProfile withId(String id) {
        return new WrappedGameProfile(id, this.getName());
    }

    public boolean isComplete() {
        return (Boolean)IS_COMPLETE.invoke(this.handle, new Object[0]);
    }

    @Override
    public String toString() {
        return String.valueOf(this.getHandle());
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getId(), this.getName()});
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof WrappedGameProfile) {
            WrappedGameProfile other = (WrappedGameProfile)obj;
            return Objects.equal((Object)this.getHandle(), (Object)other.getHandle());
        }
        return false;
    }
}

