/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.wrappers;

import com.comphenix.protocol.reflect.FuzzyReflection;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.reflect.accessors.Accessors;
import com.comphenix.protocol.reflect.accessors.MethodAccessor;
import com.comphenix.protocol.reflect.fuzzy.FuzzyMethodContract;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.utility.MinecraftVersion;
import com.comphenix.protocol.wrappers.BukkitConverters;
import com.comphenix.protocol.wrappers.WrappedBlockData;
import com.google.common.base.Preconditions;
import org.bukkit.Color;
import org.bukkit.Particle;
import org.bukkit.block.data.BlockData;
import org.bukkit.inventory.ItemStack;
import org.joml.Vector3f;

public class WrappedParticle<T> {
    private static Class<?> VECTOR_3FA;
    private static MethodAccessor toBukkit;
    private static MethodAccessor getType;
    private static MethodAccessor toNMS;
    private static MethodAccessor toCraftData;
    private final Particle particle;
    private final T data;
    private final Object handle;

    private static void ensureMethods() {
        FuzzyMethodContract contract;
        if (toBukkit != null && toNMS != null) {
            return;
        }
        Class<?> particleType = MinecraftReflection.isMojangMapped() ? MinecraftReflection.getParticleTypeClass() : MinecraftReflection.getParticleClass();
        Preconditions.checkNotNull(particleType, (Object)("Cannot find ParticleType class (MojMap: " + MinecraftReflection.isMojangMapped() + ")"));
        FuzzyReflection fuzzy = FuzzyReflection.fromClass(MinecraftReflection.getCraftBukkitClass("CraftParticle"));
        if (MinecraftVersion.CONFIG_PHASE_PROTOCOL_UPDATE.atOrAbove()) {
            contract = FuzzyMethodContract.newBuilder().requireModifier(8).returnTypeExact(Particle.class).parameterExactArray(particleType).build();
            toBukkit = Accessors.getMethodAccessor(fuzzy.getMethod(contract));
            FuzzyReflection particleParam = FuzzyReflection.fromClass(MinecraftReflection.getParticleParam(), false);
            contract = FuzzyMethodContract.newBuilder().returnTypeExact(particleType).parameterCount(0).build();
            getType = Accessors.getMethodAccessor(particleParam.getMethod(contract));
        } else {
            contract = FuzzyMethodContract.newBuilder().requireModifier(8).returnTypeExact(Particle.class).parameterExactType(MinecraftReflection.getParticleParam()).build();
            toBukkit = Accessors.getMethodAccessor(fuzzy.getMethod(contract));
        }
        contract = FuzzyMethodContract.newBuilder().requireModifier(8).returnTypeExact(MinecraftReflection.getParticleParam()).parameterCount(2).build();
        toNMS = Accessors.getMethodAccessor(fuzzy.getMethod(contract));
        Class<?> cbData = MinecraftReflection.getCraftBukkitClass("block.data.CraftBlockData");
        fuzzy = FuzzyReflection.fromClass(cbData);
        contract = FuzzyMethodContract.newBuilder().requireModifier(8).returnTypeExact(cbData).parameterExactArray(MinecraftReflection.getIBlockDataClass()).build();
        toCraftData = Accessors.getMethodAccessor(fuzzy.getMethod(contract));
    }

    private WrappedParticle(Object handle, Particle particle, T data) {
        this.handle = handle;
        this.particle = particle;
        this.data = data;
    }

    public Particle getParticle() {
        return this.particle;
    }

    public T getData() {
        return this.data;
    }

    public Object getHandle() {
        return this.handle;
    }

    public static WrappedParticle fromHandle(Object handle) {
        Particle bukkit;
        WrappedParticle.ensureMethods();
        if (MinecraftVersion.CONFIG_PHASE_PROTOCOL_UPDATE.atOrAbove()) {
            Object particle = getType.invoke(handle, new Object[0]);
            bukkit = (Particle)toBukkit.invoke(null, particle);
        } else {
            bukkit = (Particle)toBukkit.invoke(null, handle);
        }
        Object data = null;
        Class dataType = bukkit.getDataType();
        if (dataType == BlockData.class) {
            data = WrappedParticle.getBlockData(handle);
        } else if (dataType == Particle.DustTransition.class) {
            data = WrappedParticle.getDustTransition(handle);
        } else if (dataType == ItemStack.class) {
            data = WrappedParticle.getItem(handle);
        } else if (dataType == Particle.DustOptions.class) {
            data = WrappedParticle.getRedstone(handle);
        }
        return new WrappedParticle<Object>(handle, bukkit, data);
    }

    private static WrappedBlockData getBlockData(Object handle) {
        return new StructureModifier(handle.getClass()).withTarget(handle).withType(MinecraftReflection.getIBlockDataClass(), BukkitConverters.getWrappedBlockDataConverter()).read(0);
    }

    private static Object getItem(Object handle) {
        return new StructureModifier(handle.getClass()).withTarget(handle).withType(MinecraftReflection.getItemStackClass(), BukkitConverters.getItemStackConverter()).read(0);
    }

    private static Object getRedstone(Object handle) {
        float scale;
        Color color;
        StructureModifier modifier = new StructureModifier(handle.getClass()).withTarget(handle);
        if (MinecraftVersion.v1_21_2.atOrAbove()) {
            int rgb = (Integer)modifier.withType(Integer.TYPE).read(0);
            color = Color.fromRGB((int)rgb);
            scale = ((Float)modifier.withType(Float.TYPE).read(0)).floatValue();
        } else if (MinecraftVersion.FEATURE_PREVIEW_UPDATE.atOrAbove()) {
            Vector3f rgb = (Vector3f)modifier.withType(Vector3f.class).read(0);
            int red = (int)(rgb.x() * 255.0f);
            int green = (int)(rgb.y() * 255.0f);
            int blue = (int)(rgb.z() * 255.0f);
            color = Color.fromRGB((int)red, (int)green, (int)blue);
            scale = ((Float)modifier.withType(Float.TYPE).read(0)).floatValue();
        } else if (MinecraftVersion.CAVES_CLIFFS_1.atOrAbove()) {
            if (VECTOR_3FA == null) {
                VECTOR_3FA = MinecraftReflection.getLibraryClass("com.mojang.math.Vector3fa");
            }
            Object rgb = modifier.withType(VECTOR_3FA).read(0);
            StructureModifier rgbModifier = new StructureModifier(VECTOR_3FA).withTarget(rgb);
            int red = (int)(((Float)rgbModifier.withType(Float.TYPE).read(0)).floatValue() * 255.0f);
            int green = (int)(((Float)rgbModifier.withType(Float.TYPE).read(1)).floatValue() * 255.0f);
            int blue = (int)(((Float)rgbModifier.withType(Float.TYPE).read(2)).floatValue() * 255.0f);
            color = Color.fromRGB((int)red, (int)green, (int)blue);
            scale = ((Float)modifier.withType(Float.TYPE).read(0)).floatValue();
        } else {
            StructureModifier floatModifier = modifier.withType(Float.TYPE);
            int red = (int)(((Float)floatModifier.read(0)).floatValue() * 255.0f);
            int green = (int)(((Float)floatModifier.read(1)).floatValue() * 255.0f);
            int blue = (int)(((Float)floatModifier.read(2)).floatValue() * 255.0f);
            color = Color.fromRGB((int)red, (int)green, (int)blue);
            scale = ((Float)floatModifier.read(3)).floatValue();
        }
        return new Particle.DustOptions(color, scale);
    }

    private static Object getDustTransition(Object handle) {
        float scale;
        Color toColor;
        Color fromColor;
        if (MinecraftVersion.v1_21_2.atOrAbove()) {
            StructureModifier modifier = new StructureModifier(handle.getClass()).withTarget(handle);
            int fromRgb = (Integer)modifier.withType(Integer.TYPE).read(0);
            fromColor = Color.fromRGB((int)fromRgb);
            int toRgb = (Integer)modifier.withType(Integer.TYPE).read(1);
            toColor = Color.fromRGB((int)toRgb);
            scale = ((Float)modifier.withType(Float.TYPE).read(0)).floatValue();
        } else if (MinecraftVersion.FEATURE_PREVIEW_UPDATE.atOrAbove()) {
            StructureModifier modifier = new StructureModifier(handle.getClass()).withTarget(handle);
            Vector3f toRGB = (Vector3f)modifier.withType(Vector3f.class).read(1);
            Vector3f fromRGB = (Vector3f)modifier.withType(Vector3f.class).read(0);
            scale = ((Float)modifier.withType(Float.TYPE).read(0)).floatValue();
            int fromR = (int)(fromRGB.x() * 255.0f);
            int fromG = (int)(fromRGB.y() * 255.0f);
            int fromB = (int)(fromRGB.z() * 255.0f);
            fromColor = Color.fromRGB((int)fromR, (int)fromG, (int)fromB);
            int toR = (int)(toRGB.x() * 255.0f);
            int toG = (int)(toRGB.y() * 255.0f);
            int toB = (int)(toRGB.z() * 255.0f);
            toColor = Color.fromRGB((int)toR, (int)toG, (int)toB);
        } else if (MinecraftVersion.CAVES_CLIFFS_1.atOrAbove()) {
            if (VECTOR_3FA == null) {
                VECTOR_3FA = MinecraftReflection.getLibraryClass("com.mojang.math.Vector3fa");
            }
            StructureModifier modifier = new StructureModifier(handle.getClass()).withTarget(handle);
            Object toRGB = modifier.withType(VECTOR_3FA).read(0);
            Object fromRGB = modifier.withType(VECTOR_3FA).read(1);
            scale = ((Float)modifier.withType(Float.TYPE).read(0)).floatValue();
            StructureModifier rgbModifier = new StructureModifier(VECTOR_3FA).withTarget(fromRGB);
            StructureModifier rgbModifier2 = new StructureModifier(VECTOR_3FA).withTarget(toRGB);
            int fromR = (int)(((Float)rgbModifier.withType(Float.TYPE).read(0)).floatValue() * 255.0f);
            int fromG = (int)(((Float)rgbModifier.withType(Float.TYPE).read(1)).floatValue() * 255.0f);
            int fromB = (int)(((Float)rgbModifier.withType(Float.TYPE).read(2)).floatValue() * 255.0f);
            fromColor = Color.fromRGB((int)fromR, (int)fromG, (int)fromB);
            int toR = (int)(((Float)rgbModifier2.withType(Float.TYPE).read(0)).floatValue() * 255.0f);
            int toG = (int)(((Float)rgbModifier2.withType(Float.TYPE).read(1)).floatValue() * 255.0f);
            int toB = (int)(((Float)rgbModifier2.withType(Float.TYPE).read(2)).floatValue() * 255.0f);
            toColor = Color.fromRGB((int)toR, (int)toG, (int)toB);
        } else {
            StructureModifier modifier = new StructureModifier(handle.getClass()).withTarget(handle).withType(Float.TYPE);
            int toR = (int)(((Float)modifier.read(0)).floatValue() * 255.0f);
            int toG = (int)(((Float)modifier.read(1)).floatValue() * 255.0f);
            int toB = (int)(((Float)modifier.read(2)).floatValue() * 255.0f);
            toColor = Color.fromRGB((int)toR, (int)toG, (int)toB);
            scale = ((Float)modifier.read(3)).floatValue();
            int fromR = (int)(((Float)modifier.read(4)).floatValue() * 255.0f);
            int fromG = (int)(((Float)modifier.read(5)).floatValue() * 255.0f);
            int fromB = (int)(((Float)modifier.read(6)).floatValue() * 255.0f);
            fromColor = Color.fromRGB((int)fromR, (int)fromG, (int)fromB);
        }
        return new Particle.DustTransition(fromColor, toColor, scale);
    }

    public static <T> WrappedParticle<T> create(Particle particle, T data) {
        WrappedParticle.ensureMethods();
        Object bukkitData = data;
        if (data instanceof WrappedBlockData) {
            WrappedBlockData blockData = (WrappedBlockData)data;
            bukkitData = toCraftData.invoke(null, blockData.getHandle());
        }
        Object handle = toNMS.invoke(null, particle, bukkitData);
        return new WrappedParticle<T>(handle, particle, data);
    }
}

